<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * ProgramStatuses Controller
 *
 * @property \App\Model\Table\ProgramStatusesTable $ProgramStatuses
 */
class ProgramStatusesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function initialize(): void
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->viewBuilder()->setLayout('adminlayout');
    }

    public function index()
    {
        $query = $this->ProgramStatuses->find();
        $programStatuses = $this->paginate($query);

        $this->set(compact('programStatuses'));
    }

    /**
     * View method
     *
     * @param string|null $id Program Status id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $programStatus = $this->ProgramStatuses->get($id, contain: ['Programs']);
        $this->set(compact('programStatus'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $programStatus = $this->ProgramStatuses->newEmptyEntity();
        if ($this->request->is('post')) {
            $programStatus = $this->ProgramStatuses->patchEntity($programStatus, $this->request->getData());
            if ($this->ProgramStatuses->save($programStatus)) {
                $this->Flash->success(__('The program status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The program status could not be saved. Please, try again.'));
        }
        $this->set(compact('programStatus'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Program Status id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $programStatus = $this->ProgramStatuses->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $programStatus = $this->ProgramStatuses->patchEntity($programStatus, $this->request->getData());
            if ($this->ProgramStatuses->save($programStatus)) {
                $this->Flash->success(__('The program status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The program status could not be saved. Please, try again.'));
        }
        $this->set(compact('programStatus'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Program Status id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $programStatus = $this->ProgramStatuses->get($id);
        if ($this->ProgramStatuses->delete($programStatus)) {
            $this->Flash->success(__('The program status has been deleted.'));
        } else {
            $this->Flash->error(__('The program status could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
