<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * ProgramsStudents Controller
 *
 * @property \App\Model\Table\ProgramsStudentsTable $ProgramsStudents
 */
class ProgramsStudentsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function initialize(): void
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->viewBuilder()->setLayout('adminlayout');
    }

    public function index()
    {
        $query = $this->ProgramsStudents->find()
            ->contain(['Programs', 'Students']);
        $programsStudents = $this->paginate($query);

        $this->set(compact('programsStudents'));
    }

    /**
     * View method
     *
     * @param string|null $id Programs Student id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $programsStudent = $this->ProgramsStudents->get($id, contain: ['Programs', 'Students']);
        $this->set(compact('programsStudent'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $programsStudent = $this->ProgramsStudents->newEmptyEntity();
        if ($this->request->is('post')) {
            $programsStudent = $this->ProgramsStudents->patchEntity($programsStudent, $this->request->getData());
            if ($this->ProgramsStudents->save($programsStudent)) {
                $this->Flash->success(__('The programs student has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs student could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsStudents->Programs->find('list', limit: 200)->all();
        $students = $this->ProgramsStudents->Students->find('list', limit: 200)->all();
        $this->set(compact('programsStudent', 'programs', 'students'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Programs Student id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $programsStudent = $this->ProgramsStudents->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $programsStudent = $this->ProgramsStudents->patchEntity($programsStudent, $this->request->getData());
            if ($this->ProgramsStudents->save($programsStudent)) {
                $this->Flash->success(__('The programs student has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs student could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsStudents->Programs->find('list', limit: 200)->all();
        $students = $this->ProgramsStudents->Students->find('list', limit: 200)->all();
        $this->set(compact('programsStudent', 'programs', 'students'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Programs Student id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $programsStudent = $this->ProgramsStudents->get($id);
        if ($this->ProgramsStudents->delete($programsStudent)) {
            $this->Flash->success(__('The programs student has been deleted.'));
        } else {
            $this->Flash->error(__('The programs student could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
