<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Doc Entity
 *
 * @property int $id
 * @property string $docuniqueid
 * @property string $volunteer
 * @property string $name
 * @property string $badges
 * @property string $certified
 * @property \Cake\I18n\Date $issue_date
 * @property string $program_name1
 * @property string|null $program_name2
 * @property string|null $program_name3
 */
class Doc extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'docuniqueid' => true,
        'volunteer' => true,
        'name' => true,
        'badges' => true,
        'certified' => true,
        'issue_date' => true,
        'program_name1' => true,
        'program_name2' => true,
        'program_name3' => true,
    ];
}
