<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Program Entity
 *
 * @property int $id
 * @property string $name
 * @property \Cake\I18n\Date $date
 * @property \Cake\I18n\Time $time
 * @property int|null $program_status_id
 *
 * @property \App\Model\Entity\ProgramStatus $program_status
 * @property \App\Model\Entity\ProgramsImage[] $programs_images
 * @property \App\Model\Entity\Student[] $students
 * @property \App\Model\Entity\Volunteer[] $volunteers
 */
class Program extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'date' => true,
        'time' => true,
        'program_status_id' => true,
        'program_status' => true,
        'programs_images' => true,
        'students' => true,
        'volunteers' => true,
    ];
}
