<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProgramStatuses Model
 *
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\HasMany $Programs
 *
 * @method \App\Model\Entity\ProgramStatus newEmptyEntity()
 * @method \App\Model\Entity\ProgramStatus newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramStatus> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProgramStatus get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProgramStatus findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProgramStatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramStatus> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProgramStatus|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProgramStatus saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramStatus>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramStatus> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramStatus>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramStatus> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProgramStatusesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('program_statuses');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('Programs', [
            'foreignKey' => 'program_status_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
     {
         $validator
             ->scalar('name')
             ->maxLength('name', 50, 'Status name must not exceed 50 characters.')
             ->requirePresence('name', 'create')
             ->notEmptyString('name', 'Program status name is required.')
             ->add('name', 'alphaOnly', [
                 'rule' => function ($value, $context) {
                     return preg_match('/^[a-zA-Z\s]+$/', $value) === 1; 
                 },
                 'message' => 'Only letters and spaces are allowed in the program status name.'
             ]);
     
         return $validator;
     }
}
