<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProgramsImages Model
 *
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\BelongsTo $Programs
 *
 * @method \App\Model\Entity\ProgramsImage newEmptyEntity()
 * @method \App\Model\Entity\ProgramsImage newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsImage> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsImage get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProgramsImage findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProgramsImage patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsImage> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsImage|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProgramsImage saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsImage>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsImage> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsImage>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsImage> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProgramsImagesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('programs_images');
        $this->setDisplayField('image_name');
        $this->setPrimaryKey('id');

        $this->belongsTo('Programs', [
            'foreignKey' => 'program_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('image_name')
            ->maxLength('image_name', 100)
            ->requirePresence('image_name', 'create')
            ->notEmptyString('image_name');

            $validator
            ->integer('program_id')
            ->requirePresence('program_id', 'create')
            ->notEmptyString('program_id', 'Please select a program');
        

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['program_id'], 'Programs'), ['errorField' => 'program_id']);

        return $rules;
    }
}
