<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProgramsSections Model
 *
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\BelongsTo $Programs
 *
 * @method \App\Model\Entity\ProgramsSection newEmptyEntity()
 * @method \App\Model\Entity\ProgramsSection newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsSection> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsSection get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProgramsSection findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProgramsSection patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsSection> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsSection|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProgramsSection saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsSection>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsSection>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsSection>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsSection> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsSection>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsSection>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsSection>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsSection> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProgramsSectionsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('programs_sections');
        $this->setDisplayField('title');
        $this->setPrimaryKey('id');

        $this->belongsTo('Programs', [
            'foreignKey' => 'program_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('title')
            ->maxLength('title', 128)
            ->requirePresence('title', 'create')
            ->notEmptyString('title');

        $validator
            ->scalar('body')
            ->maxLength('body', 10000)
            ->requirePresence('body', 'create')
            ->notEmptyString('body');

        $validator
            ->integer('program_id')
            ->notEmptyString('program_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['program_id'], 'Programs'), ['errorField' => 'program_id']);

        return $rules;
    }
}
