<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StudentStatuses Model
 *
 * @property \App\Model\Table\StudentsTable&\Cake\ORM\Association\HasMany $Students
 *
 * @method \App\Model\Entity\StudentStatus newEmptyEntity()
 * @method \App\Model\Entity\StudentStatus newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\StudentStatus> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\StudentStatus get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\StudentStatus findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\StudentStatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\StudentStatus> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\StudentStatus|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\StudentStatus saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\StudentStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\StudentStatus>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\StudentStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\StudentStatus> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\StudentStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\StudentStatus>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\StudentStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\StudentStatus> deleteManyOrFail(iterable $entities, array $options = [])
 */
class StudentStatusesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('student_statuses');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('Students', [
            'foreignKey' => 'student_status_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 50, 'Status name must not exceed 50 characters.')
            ->requirePresence('name', 'create')
            ->notEmptyString('name', 'Student status name is required.')
            ->add('name', 'alphaOnly', [
                'rule' => function ($value, $context) {
                    return preg_match('/^[a-zA-Z\s]+$/', $value) === 1;
                },
                'message' => 'Only letters and spaces are allowed in the student status name.'
            ]);
    
        return $validator;
    }
    
}
