<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Students Model
 *
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\BelongsToMany $Programs
 *
 * @method \App\Model\Entity\Student newEmptyEntity()
 * @method \App\Model\Entity\Student newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Student> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Student get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Student findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Student patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Student> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Student|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Student saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Student>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Student>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Student>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Student> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Student>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Student>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Student>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Student> deleteManyOrFail(iterable $entities, array $options = [])
 */
class StudentsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('students');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->belongsToMany('Programs', [
            'foreignKey' => 'student_id',
            'targetForeignKey' => 'program_id',
            'joinTable' => 'programs_students',
            'cascadeCallbacks' => true,
        ]);

        $this->belongsTo('StudentStatuses', [
            'foreignKey' => 'student_status_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
{
    // First name – required, only letters and spaces
    $validator
        ->requirePresence('first_name', 'create')
        ->notEmptyString('first_name', 'First name is required.')
        ->add('first_name', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces are allowed in first name.'
        ]);

    // Last name – required, only letters and spaces
    $validator
        ->requirePresence('last_name', 'create')
        ->notEmptyString('last_name', 'Last name is required.')
        ->add('last_name', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces are allowed in last name.'
        ]);

    // Email – required, valid format
    $validator
        ->requirePresence('email', 'create')
        ->notEmptyString('email', 'Email address is required.')
        ->email('email', false, 'Please provide a valid email address.');

    // Phone – required, numeric, exactly 10 digits
    $validator
        ->requirePresence('phone', 'create')
        ->notEmptyString('phone', 'Phone number is required.')
        ->add('phone', 'numeric', [
            'rule' => ['custom', '/^\d{10}$/'],
            'message' => 'Phone number must be exactly 10 digits.'
        ]);

    // Postcode – required, numeric only
    $validator
        ->requirePresence('postcode', 'create')
        ->notEmptyString('postcode', 'Postcode is required.')
        ->add('postcode', 'numeric', [
            'rule' => ['custom', '/^\d+$/'],
            'message' => 'Postcode must be numeric.'
        ]);

    // Occupation – required, letters and spaces only
    $validator
        ->requirePresence('occupation', 'create')
        ->notEmptyString('occupation', 'Occupation is required.')
        ->add('occupation', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces are allowed in occupation.'
        ]);

    // Description – required
    $validator
        ->requirePresence('description', 'create')
        ->notEmptyString('description', 'Description is required.');

    return $validator;
}

    
    }

