<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class TemplateRecipientsTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('template_recipients'); // must match your DB table name
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp'); // manages created/modified timestamps automatically
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->requirePresence('recipient_email', 'create')
            ->notEmptyString('recipient_email', 'Email is required')
            ->email('recipient_email', false, 'Must be a valid email');

        return $validator;
    }
}
