<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class TemplatesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('templates'); // table name in your database
        $this->setPrimaryKey('id');
        $this->setDisplayField('name'); // optional, for form dropdowns etc.
        $this->addBehavior('Timestamp'); // adds created/modified auto timestamps
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->notEmptyString('name', 'Name is required')
            ->notEmptyString('content', 'Content cannot be empty');

        return $validator;
    }
}
