<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VolunteerStatuses Model
 *
 * @property \App\Model\Table\VolunteersTable&\Cake\ORM\Association\HasMany $Volunteers
 *
 * @method \App\Model\Entity\VolunteerStatus newEmptyEntity()
 * @method \App\Model\Entity\VolunteerStatus newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\VolunteerStatus> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\VolunteerStatus get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\VolunteerStatus findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\VolunteerStatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\VolunteerStatus> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\VolunteerStatus|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\VolunteerStatus saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\VolunteerStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VolunteerStatus>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VolunteerStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VolunteerStatus> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VolunteerStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VolunteerStatus>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VolunteerStatus>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VolunteerStatus> deleteManyOrFail(iterable $entities, array $options = [])
 */
class VolunteerStatusesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('volunteer_statuses');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('Volunteers', [
            'foreignKey' => 'volunteer_status_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 50, 'Status name must not exceed 50 characters.')
            ->requirePresence('name', 'create')
            ->notEmptyString('name', 'Volunteer status name is required.')
            ->add('name', 'alphaOnly', [
                'rule' => function ($value, $context) {
                    return preg_match('/^[a-zA-Z\s]+$/', $value) === 1; 
                },
                'message' => 'Only letters and spaces are allowed in the volunteer status name.'
            ]);
    
        return $validator;
    }
    
}

