<?php
// src/View/Helper/ContentBlockHelper.php
namespace App\View\Helper;

use Cake\View\Helper;
use Cake\View\Helper\HtmlHelper;

class ContentBlockHelper extends Helper
{
    protected array $helpers = ['Html']; // FIXED: added `array` type
    public function image($path, array $options = [])
    {
        // Resolve the image path
        $imagePath = $this->getImagePath($path);

        // Merge default options
        $defaultOptions = [
            'class' => '',
            'alt' => 'Image',
        ];
        $options = array_merge($defaultOptions, $options);

        // Generate the image tag
        return $this->Html->image($imagePath, $options);
    }

    protected function getImagePath($path)
    {
        // Handle dynamic logo path from session data if needed
        $certData = $this->_View->getRequest()->getSession()->read('Certificate.data');
        if ($path === 'website-logo' && !empty($certData['organization_logo_path'])) {
            return $certData['organization_logo_path'];
        }

        // Fallback to a default image
        $defaultPath = 'img/website-logo.png';
        return file_exists(WWW_ROOT . $defaultPath) ? $defaultPath : 'img/default-logo.png';
    }
}
