<?php
namespace App\View\Helper;

use Cake\View\Helper;
use Cake\I18n\FrozenTime;

class DateHelper extends Helper
{
    public function formatDate($date)
    {
        if ($date instanceof \DateTime) {
            return $date->format('d/m/Y');
        }

        return FrozenTime::parse($date)->i18nFormat('dd/MM/YYYY');
    }
}