<?php
/**
 * @var \App\View\AppView $this
 */
$this->layout = 'login';
$this->assign('title', 'Forget Password');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= $this->request->getAttribute('csrfToken') ?>">
    <title>Forget Password</title>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css') ?>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
    <style>
        :root {
            --orange: #E87533;
            --orange-light: #FFA563;
            --orange-dark: #D05F20;
            --blue: #3E88F2;
            --blue-light: #70A8FF;
            --green: #2EA876;
            --grey-light: #f5f5f5;
            --grey-lighter: #fafafa;
            --grey: #78716c;
            --grey-dark: #4B4945;
            --radius: 20px;
            --radius-sm: 12px;
            --spacing: 30px;
            --shadow: rgba(0,0,0,0.1);
            --shadow-hover: rgba(0,0,0,0.2);
            --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
        }

        * { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            font-family: "Inter", system-ui, sans-serif;
            background: var(--grey-lighter);
            color: #333;
            line-height: 1.6;
            overflow-x: hidden;
            min-height: 100vh;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
            radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
            z-index: -1;
        }

        .login-container {
            min-height: 100vh;
            width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            background: linear-gradient(145deg, var(--orange-dark) 0%, var(--orange-light) 40%, var(--blue) 100%);
            background-size: 300% 300%;
            animation: gradientPulse 10s ease infinite;
            position: relative;
            overflow: hidden;
        }

        .login-container::before {
            content: '';
            position: absolute;
            inset: 0;
            background: url('data:image/svg+xml;utf8,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><path d="M30 0 L60 30 L30 60 L0 30 Z" fill="none" stroke="rgba(255,255,255,0.2)" stroke-width="1.5"/></svg>');
            background-size: 60px 60px;
            opacity: 0.25;
            animation: patternDrift 25s linear infinite;
        }

        .login-inner {
            background: #fff;
            padding: calc(var(--spacing) * 2);
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            max-width: 600px;
            width: 90%;
            position: relative;
            z-index: 1;
        }

        @keyframes gradientPulse {
            0% { background-position: 0% 0%; }
            50% { background-position: 100% 100%; }
            100% { background-position: 0% 0%; }
        }

        @keyframes patternDrift {
            0% { background-position: 0 0; }
            100% { background-position: 60px 60px; }
        }

        .login-sparkles {
            position: absolute;
            inset: 0;
            pointer-events: none;
            z-index: 0;
        }

        .sparkle {
            position: absolute;
            width: 6px;
            height: 6px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            animation: sparkleDance 4s infinite ease-in-out;
        }

        @keyframes sparkleDance {
            0% { transform: scale(0.5); opacity: 0; }
            50% { transform: scale(1.2); opacity: 0.8; }
            100% { transform: scale(0.5); opacity: 0; }
        }

        .login-title {
            font-family: "Poppins", sans-serif;
            font-size: clamp(2.2rem, 6vw, 3rem);
            font-weight: 700;
            text-align: center;
            color: var(--orange-dark);
            margin-bottom: 0.5rem;
            text-shadow: 0 3px 10px rgba(0,0,0,0.2);
        }

        .login-subtitle {
            font-size: clamp(1rem, 3vw, 1.3rem);
            text-align: center;
            color: var(--grey);
            margin-bottom: calc(var(--spacing) * 1.5);
            font-weight: 300;
        }

        .form-group {
            margin-bottom: calc(var(--spacing) * 1);
            width: 100%;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border: 2px solid var(--grey-light);
            border-radius: var(--radius-sm);
            font-size: clamp(0.875rem, 2.5vw, 1rem);
            color: var(--grey-dark);
            transition: var(--transition);
            background: var(--grey-lighter);
        }

        .form-input:focus {
            outline: none;
            border-color: var(--orange-light);
            box-shadow: 0 0 8px rgba(232, 117, 51, 0.3);
            transform: scale(1.02);
        }

        .submit-btn {
            width: 100%;
            padding: 16px;
            background: var(--orange);
            color: #fff;
            border: none;
            border-radius: var(--radius-sm);
            font-size: clamp(1rem, 2.5vw, 1.2rem);
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 8px 25px rgba(232, 117, 51, 0.25);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .submit-btn:hover {
            background: var(--orange-dark);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
        }

        .hr-between-buttons {
            border: 0;
            border-top: 1px solid var(--grey-light);
            margin: calc(var(--spacing) * 1) 0;
        }

        .login-footer {
            text-align: center;
            font-size: clamp(0.875rem, 2vw, 1rem);
            color: var(--grey);
            margin-top: 1rem;
        }

        .login-footer a {
            color: var(--orange);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
        }

        .login-footer a:hover {
            color: var(--orange-dark);
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .login-container {
                padding: 15px;
            }

            .login-inner {
                padding: calc(var(--spacing) * 1);
                width: 95%;
            }

            .login-title {
                font-size: clamp(1.8rem, 5vw, 2.2rem);
            }

            .login-subtitle {
                font-size: clamp(0.875rem, 2.5vw, 1rem);
            }

            .form-input {
                padding: 10px;
                font-size: clamp(0.75rem, 2vw, 0.875rem);
            }

            .submit-btn {
                padding: 12px;
                font-size: clamp(0.875rem, 2vw, 1rem);
            }

            .login-footer {
                font-size: clamp(0.75rem, 1.8vw, 0.875rem);
            }
        }
    </style>
    <?= $this->Html->script([
        'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js',
        'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js'
    ]) ?>
</head>
<body>
<div class="login-container">
    <div class="login-sparkles">
        <div class="sparkle" style="left: 15%; top: 20%; animation-delay: 0s;"></div>
        <div class="sparkle" style="left: 85%; top: 40%; animation-delay: 1s;"></div>
        <div class="sparkle" style="left: 50%; top: 70%; animation-delay: 2s;"></div>
        <div class="sparkle" style="left: 30%; top: 50%; animation-delay: 3s;"></div>
    </div>
    <div class="login-inner">
        <h1 class="login-title">Forget Password</h1>
        <p class="login-subtitle">Enter your email to reset your password</p>

        <?= $this->Form->create() ?>
        <?php echo $this->Flash->render(); ?>

        <div class="form-group animate-field">
            <p style="color: var(--grey); margin-bottom: 10px;">Enter your email address registered with our system below to reset your password:</p>
            <?= $this->Form->control('email', [
                'type' => 'email',
                'required' => true,
                'autofocus' => true,
                'label' => false,
                'placeholder' => 'Email',
                'class' => 'form-input'
            ]) ?>
        </div>

        <div class="form-group">
            <?= $this->Form->button('Send verification email', ['class' => 'submit-btn']) ?>
        </div>

        <hr class="hr-between-buttons">
        <p class="login-footer">
            <?= $this->Html->link('Login Account', ['controller' => 'Auth', 'action' => 'login']) ?>
        </p>

        <?= $this->Form->end() ?>
    </div>
</div>

<script>
    gsap.registerPlugin(ScrollTrigger);

    document.addEventListener('DOMContentLoaded', () => {
        // Scroll Animation for Login Inner
        gsap.from('.login-inner', {
            opacity: 0,
            y: 50,
            duration: 1,
            ease: 'power3.out',
            scrollTrigger: {
                trigger: '.login-inner',
                start: 'top 85%',
            }
        });

        // Animate Form Fields
        gsap.utils.toArray('.animate-field').forEach((el, i) => {
            gsap.from(el, {
                opacity: 0,
                x: -20,
                duration: 0.8,
                ease: 'power3.out',
                delay: i * 0.2,
                scrollTrigger: {
                    trigger: '.login-inner',
                    start: 'top 85%',
                }
            });
        });
    });
</script>
</body>
</html>
