<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Badge $badge
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">

    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Add Badge</h5>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Badges',
                        ['action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                    ) ?>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($badge, ['class' => 'row g-3']) ?>

                    <!-- Badge Text Field -->
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="text-badge">Badge Text</label>
                            <?= $this->Form->control('text_badge', [
                                'required' => true,
                                'maxlength' => 25,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter badge text (letters, numbers only)',
                                'id' => 'text-badge'
                            ]) ?>
                            <div id="char-counter" class="form-text text-end text-muted">0/25</div>
                            <div id="char-warning" class="form-text text-danger" style="display:none;">
                                Special characters are not allowed.
                            </div>
                        </div>
                    </div>

                    <!-- Submit Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Create Badge'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Character & Input Filter Script -->
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const input = document.getElementById('text-badge');
        const counter = document.getElementById('char-counter');
        const warning = document.getElementById('char-warning');

        const update = () => {
            // Remove special characters and update field
            let cleaned = input.value.replace(/[^a-zA-Z0-9 ]/g, '');
            if (input.value !== cleaned) {
                warning.style.display = 'block';
            } else {
                warning.style.display = 'none';
            }

            input.value = cleaned;

            // Update character count
            const length = cleaned.length;
            counter.textContent = `${length}/25`;
            counter.classList.toggle('text-danger', length >= 25);
        };

        input.addEventListener('input', update);
        update(); // Initial run
    });
</script>
