<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Campaign> $campaigns
 */
?>

<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Campaign Management</h5>
                    <?= $this->Html->link('New Campaign', ['action' => 'add'], ['class' => 'btn btn-primary ms-3']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('id') ?></th>
                                <th><?= $this->Paginator->sort('title') ?></th>
                                <th><?= $this->Paginator->sort('goal_amount') ?></th>
                                <th><?= $this->Paginator->sort('created') ?></th>
                                <th><?= $this->Paginator->sort('modified') ?></th>
                                <th>Status</th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($campaigns as $campaign): ?>
                                <tr>
                                    <td><?= $this->Number->format($campaign->id) ?></td>
                                    <td><?= h($campaign->title) ?></td>
                                    <td><?= $campaign->goal_amount === null ? '' : $this->Number->format($campaign->goal_amount) ?></td>
                                    <td><?= $campaign->created->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                                    <td><?= $campaign->modified->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                                    <td>
                                        <?php if ($campaign->is_active == 1): ?>
                                            <span class="badge bg-success">Open</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Closed</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="actions">
                                        <!-- View button -->
                                        <?= $this->Html->link(__('View'), ['action' => 'view', $campaign->id], ['class' => 'btn btn-info btn-sm']) ?>
                                        <!-- Edit button -->
                                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $campaign->id], ['class' => 'btn btn-warning btn-sm']) ?>
                                        <!-- Delete button with confirmation -->
                                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $campaign->id], [
                                            'confirm' => __('Are you sure you want to delete # {0}?', $campaign->id),
                                            'class' => 'btn btn-danger btn-sm'
                                        ]) ?>
                                        <!-- Toggle active/inactive -->
                                        <?php if ($campaign->is_active): ?>
                                            <?= $this->Form->postLink(__('Close'), ['action' => 'toggleVisibility', $campaign->id], [
                                                'class' => 'btn btn-outline-secondary btn-sm'
                                            ]) ?>
                                        <?php else: ?>
                                            <?= $this->Form->postLink(__('Reopen'), ['action' => 'toggleVisibility', $campaign->id], [
                                                'class' => 'btn btn-outline-success btn-sm'
                                            ]) ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total') ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>