<?php
/**
 * @var \App\View\AppView $this
 * @var array $programs
 * @var \App\Model\Entity\Volunteer $volunteer
 */

?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Certificate Generator</h5>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Volunteers List',
                        ['controller' => 'Volunteers', 'action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                    ) ?>
                </div>
                <div class="card-body">
                    <?= $this->Form->create(null, ['class' => 'row g-3', 'type' => 'file']) ?>
                    <fieldset>
                        <legend class="mb-3">Design Your Certificate</legend>

                        <!-- Recipient and Badge -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="recipient-name">Recipient Name *</label>
                                <?= $this->Form->control('recipient_name', [
                                    'required' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter recipient name',
                                    'default' => $volunteer->first_name.' '.$volunteer->last_name,
                                    'id' => 'recipient-name',
                                    'maxlength' => 50,
                                    'disabled' => true
                                ]) ?>
                                <?= $this->Form->hidden('recipient_name', [
                                    'required' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter recipient name',
                                    'default' => $volunteer->first_name.' '.$volunteer->last_name,
                                    'id' => 'recipient-name',
                                    'maxlength' => 50,
//                                    'disabled' => true
                                ]) ?>
                            </div>
                            <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/30</div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="badge">Badge *</label>
                                <?= $this->Form->control('badge1', [
                                    'empty' => '-- Select Badge --',
                                    'required' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter badge name',
                                    'id' => 'text-badge',
                                    'maxlength' => 20
                                ]) ?>
                                <small class="form-text text-muted">For example: Excellent, Good, Outstanding – use a word that reflects the badge level.</small>

                                
                                <div id="badge-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/20</div>
                            </div>
                        </div>


                        <!-- Custom Text and Logo -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="custom-text">Certificate Text</label>
                                <?= $this->Form->control('custom_text', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'for helpful contributions in',
                                    'default' => 'for helpful contributions in',
                                    'id' => 'custom-text',
                                    'maxlength' => 50
                                ]) ?>
                                <div id="char-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label fw-bold" for="program-select">Programs *</label>
                                <?php if (empty($programs)): ?>
                                    <select class="form-select" id="program-select" disabled>
                                        <option>No programs available at the moment</option>
                                    </select>
                                    <small class="form-text text-danger mt-1">
                                        No programs found. Please add some programs before generating a certificate.
                                    </small>
                                <?php else: ?>
                                    <select name="programs[]" class="form-select" id="program-select" multiple required style="height: 150px;">
                                        <?php foreach ($programs as $program): ?>
                                            <option value="<?= h($program['id']) ?>"
                                                <?= (!empty($data['programs']) && in_array($program['id'], (array)$data['programs'])) ? 'selected' : '' ?>>
                                                <?= h($program['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <small class="form-text text-muted mt-1">
                                        Select 1 to 3 programs (Click to select or deselect).
                                    </small>
                                <?php endif; ?>
                                <div id="program-error" class="invalid-feedback">
                                    Please select between 1 to 3 programs.
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-3 ">
<!--                                <label class="form-label" for="include-banner">Include Banner?</label>-->
<!--                                <div class="form-check">-->
                                    <?= $this->Form->hidden('include_banner', [
                                        'type' => 'checkbox',
                                        'class' => 'form-check-input',
                                        'label' => false,
                                        'checked' => true,
                                        'id' => 'include-banner'
                                    ]) ?>
<!--                                    <label class="form-check-label" for="include-banner">Yes</label>-->
<!--                                </div>-->
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="col-12">
                            <?= $this->Form->button(__('Generate'), [
                                'name' => 'action',
                                'value' => 'preview',
                                'class' => 'btn btn-primary me-2',
                                'disabled' => empty($programs)
                            ]) ?>

                            <?= $this->Html->link(
                                __('Cancel'),
                                ['controller' => 'Volunteers', 'action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>
                    </fieldset>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    #program-select {
        border-radius: 8px;
        padding: 10px;
        transition: border-color 0.3s ease;
    }
    #program-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 5px rgba(78, 115, 223, 0.3);
    }
    #program-select option {
        padding: 8px;
        position: relative;
    }
    #program-select option:checked {
        background-color: #e7f1ff;
        color: #4e73df;
        font-weight: 500;
    }
    #program-select option:checked::before {
        content: '\2713';
        display: inline-block;
        width: 20px;
        height: 20px;
        margin-right: 8px;
        color: #4e73df;
        font-weight: bold;
        vertical-align: middle;
    }
    .form-text {
        font-size: 0.85rem;
    }
    .invalid-feedback {
        display: none;
        font-size: 0.9rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
</style>

<?= $this->Html->script('certificate-editor.js') ?>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const textarea = document.getElementById('custom-text');
        const nameInput = document.getElementById('recipient-name');
        const badgeInput = document.getElementById('text-badge');
        const charCounter = document.getElementById('char-counter');
        const receiptCounter = document.getElementById('name-counter');
        const badgeCounter = document.getElementById('badge-counter');
        const programSelect = document.getElementById('program-select');
        const form = document.querySelector('form');

        function validateAndTrim(input, maxLength) {
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            return sanitized.length > maxLength ? sanitized.substring(0, maxLength) : sanitized;
        }

        function validateAndTrimName(input, maxLength) {
            let sanitized = input.replace(/[^a-zA-Z .,\'"-]/g, '');
            return sanitized.length > maxLength ? sanitized.substring(0, maxLength) : sanitized;
        }

        function validateAndTrimBadge(input, maxLength) {
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            return sanitized.length > maxLength ? sanitized.substring(0, maxLength) : sanitized;
        }

        function updateCounters() {
            textarea.value = validateAndTrim(textarea.value, 50);
            nameInput.value = validateAndTrimName(nameInput.value, 30);
            badgeInput.value = validateAndTrimBadge(badgeInput.value, 20);
            charCounter.textContent = `Characters: ${textarea.value.length}/50${textarea.value.length === 50 ? ' (Maximum reached)' : ''}`;
            receiptCounter.textContent = `Characters: ${nameInput.value.length}/30${nameInput.value.length === 30 ? ' (Maximum reached)' : ''}`;
            badgeCounter.textContent = `Characters: ${badgeInput.value.length}/20${badgeInput.value.length === 20 ? ' (Maximum reached)' : ''}`;
            charCounter.style.color = textarea.value.length === 50 ? 'red' : '#555';
            receiptCounter.style.color = nameInput.value.length === 30 ? 'red' : '#555';
            badgeCounter.style.color = badgeInput.value.length === 20 ? 'red' : '#555';
        }

        updateCounters();
        textarea.addEventListener('input', updateCounters);
        nameInput.addEventListener('input', updateCounters);
        badgeInput.addEventListener('input', updateCounters);

        if (programSelect && !programSelect.disabled) {
            function updateOptionStyles() {
                const options = programSelect.querySelectorAll('option');
                options.forEach(option => {
                    option.style.paddingLeft = option.selected ? '28px' : '8px';
                });
            }

            programSelect.addEventListener('mousedown', (e) => {
                if (e.target.tagName === 'OPTION') {
                    e.preventDefault();
                    const clickedOption = e.target;
                    const selectedOptions = [...programSelect.selectedOptions];
                    if (clickedOption.selected) {
                        clickedOption.selected = false;
                    } else if (selectedOptions.length < 3) {
                        clickedOption.selected = true;
                    }
                    programSelect.dispatchEvent(new Event('change'));
                }
            });

            programSelect.addEventListener('change', () => {
                const selectedOptions = [...programSelect.selectedOptions];
                if (selectedOptions.length > 3 || selectedOptions.length < 1) {
                    programSelect.classList.add('is-invalid');
                } else {
                    programSelect.classList.remove('is-invalid');
                }
                updateOptionStyles();
            });

            form.addEventListener('submit', (e) => {
                const selectedCount = [...programSelect.selectedOptions].length;
                if (selectedCount < 1 || selectedCount > 3) {
                    programSelect.classList.add('is-invalid');
                    e.preventDefault();
                } else {
                    programSelect.classList.remove('is-invalid');
                }
            });

            updateOptionStyles();
        }
    });
</script>
