<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Doc> $doc
 */
?>
<!-- Content -->
<div class="container-xxl flex-grow-2 container-p-y">
    <!-- Render flash messages -->
    <?= $this->Flash->render() ?>

    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow);">
                <div class="modal-header" style="border-bottom: 1px solid var(--grey-light);">
                    <h5 class="modal-title" id="uploadModalLabel" style="color: var(--orange-dark); font-weight: 700;">Upload Certificate File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= $this->Form->create(null, ['type' => 'file', 'url' => ['action' => 'upload'], 'id' => 'uploadForm']) ?>
                    <div class="mb-3">
                        <label for="fileInput" class="form-label" style="color: var(--grey-dark);">Select CSV File</label>
                        <?= $this->Form->file('uploaded_file', [
                            'class' => 'form-control',
                            'id' => 'fileInput',
                            'required' => true,
                            'accept' => '.csv',
                            'style' => 'border: 1px solid var(--grey-light); border-radius: var(--radius-sm);'
                        ]) ?>
                        <small class="form-text text-muted">Accepted formats: <span style="color: var(--orange);">.csv</span> only</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--grey-dark);">Sample Data Format</label>
                        <div class="image-container">
                            <img src="<?= $this->Url->build('/img/certificate_sample.png') ?>" alt="Certificate Sample Image" class="img-fluid" style="border-radius: var(--radius-sm);">
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid var(--grey-light);">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: var(--radius-sm); color: var(--grey-dark); background: var(--grey-light); border: none;">Cancel</button>
                    <?= $this->Form->button('Upload', [
                        'type' => 'submit',
                        'class' => 'btn btn-primary',
                        'id' => 'uploadButton',
                        'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);'
                    ]) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>Certificates</h3>
                    <div>
<!--                        --><?php //= $this->Html->link(
//                            'Add Certificate',
//                            ['action' => 'add'],
//                            ['class' => 'btn btn-primary', 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);']
//                        ) ?>
                    </div>
                </div>
                <div class="card-body" style="padding: calc(var(--spacing) * 1.5);">
                    <div class="d-flex justify-content-end mb-4">
                        <?= $this->Form->create(null, ['type' => 'get']) ?>
                        <div class="input-group mb-3" style="max-width: 400px;">
                            <?= $this->Form->control('search', [
                                'label' => false,
                                'value' => $this->request->getQuery('search'),
                                'class' => 'form-control',
                                'placeholder' => 'Search certificate ID or volunteer name',
                                'type' => 'text',
                                'style' => 'min-width: 300px; border: 1px solid var(--grey-light); border-radius: var(--radius-sm); color: var(--grey-dark);'
                            ]) ?>
                            <?= $this->Form->button('Search', [
                                'class' => 'btn btn-primary',
                                'style' => 'margin-left: 8px; background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; transition: var(--transition);'
                            ]) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                            <thead style="background: var(--grey-lighter);">
                            <tr>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('docuniqueid', 'Certificate ID') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('volunteer', 'Volunteer Name') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('issue_date', 'Issue Date') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('program_name1', 'Program Name 1') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('program_name2', 'Program Name 2') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('program_name3', 'Program Name 3') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Actions</th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($doc as $doc): ?>
                                <tr >
                                    <td style="color: var(--grey-dark);"><?= h($doc->docuniqueid) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($doc->volunteer) ?></td>
                                    <td style="color: var(--grey-dark);"><?= $this->Time->format($doc->issue_date, 'MM/dd/yyyy') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($doc->program_name1) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($doc->program_name2) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($doc->program_name3) ?></td>
                                    <td>
                                        <?= $this->Html->link(__('View'), ['action' => 'preview1', $doc->id], [
                                            'class' => 'btn btn-primary',
                                            'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 600; transition: var(--transition);'
                                        ]) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="fas fa-chevron-double-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->prev('<i class="fas fa-chevron-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}" style="color: var(--blue);">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#" style="background: var(--orange); border-color: var(--orange); color: #fff;">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>
                                <?= $this->Paginator->next('<i class="fas fa-chevron-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->last('<i class="fas fa-chevron-double-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2" style="color: var(--grey);">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
    }

    .container-xxl {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 8px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
    }

    .btn-primary:hover, .btn-outline-primary:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .table-striped tbody tr {
        background: #fff;
        box-shadow: none;
        transform: none;
    }

    .table-striped tbody tr:hover {
        background: var(--grey-light);
    }

    .table a {
        color: #D05F20;
        font-weight: 600;
        text-decoration: none;
    }

    .table a:hover {
        text-decoration: underline;
        color: #B84D15;
    }

    .btn-outline-primary:hover {
        background: var(--blue);
        color: #fff;
    }

    .pagination .page-link:hover {
        background: var(--orange-light);
        color: #fff;
    }

    .download-container {
        text-align: center;
        margin: 20px;
    }

    .download-link {
        display: inline-block;
        padding: 12px 20px;
        background: var(--orange);
        color: #fff;
        font-size: 16px;
        font-weight: 700;
        text-decoration: none;
        border-radius: var(--radius-sm);
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(232, 117, 51, 0.25);
    }

    .download-link:hover {
        background: var(--orange-dark);
        color: #fff;
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .download-icon {
        margin-right: 8px;
    }
</style>

<style>
    @media (max-width: 768px) {
        .container-xxl {
            padding: 15px;
        }

        .card-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .input-group.mb-3 {
            flex-direction: column;
            width: 100%;
        }

        .input-group.mb-3 input,
        .input-group.mb-3 button {
            width: 100% !important;
            margin-top: 8px;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .pagination .page-item {
            font-size: 14px;
        }

        .modal-dialog {
            max-width: 100%;
            margin: 0 10px;
        }

        .card-body .d-flex {
            flex-direction: column;
            align-items: stretch;
        }
    }
</style>

<!-- Add JavaScript at the bottom -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        uploadForm.addEventListener('submit', function (event) {
            setTimeout(() => {
                uploadModal.hide();
            }, 500);
        });

        const tbody = document.querySelector('tbody');
        tbody.addEventListener('click', function(event) {
            const row = event.target.closest('.clickable-row');
            if (row && !event.target.closest('a.btn')) {
                const editUrl = row.getAttribute('data-edit-url');
                if (editUrl) {
                    window.location.href = editUrl;
                }
            }
        });

        // Table animation
        gsap.from('.table', {
            opacity: 0,
            y: 50,
            duration: 1,
            ease: 'power3.out'
        });
    });
</script>
