<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Document $document
 * @var string[]|\Cake\Collection\CollectionInterface $volunteers
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $document->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $document->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Document'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="document form content">
            <?= $this->Form->create($document) ?>
            <fieldset>
                <legend><?= __('Edit Document') ?></legend>
                <?php
                    echo $this->Form->control('docuniqueid');
                    echo $this->Form->control('volunteer_id', ['options' => $volunteers]);
                    echo $this->Form->control('name');
                    echo $this->Form->control('badges');
                    echo $this->Form->control('certified');
                    echo $this->Form->control('issue_date', ['empty' => true]);
                    echo $this->Form->control('program_name1');
                    echo $this->Form->control('program_name2');
                    echo $this->Form->control('program_name3');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
