<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Document $document
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Document'), ['action' => 'edit', $document->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Document'), ['action' => 'delete', $document->id], ['confirm' => __('Are you sure you want to delete # {0}?', $document->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Documents'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Document'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="documents view content">
            <h3><?= h($document->docuniqueid) ?></h3>
            <table>
                <tr>
                    <th><?= __('Docuniqueid') ?></th>
                    <td><?= h($document->docuniqueid) ?></td>
                </tr>
                <tr>
                    <th><?= __('Program') ?></th>
                    <td><?= $document->hasValue('program') ? $this->Html->link($document->program->name, ['controller' => 'Programs', 'action' => 'view', $document->program->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Volunteer') ?></th>
                    <td><?= $document->hasValue('volunteer') ? $this->Html->link($document->volunteer->first_name, ['controller' => 'Volunteers', 'action' => 'view', $document->volunteer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($document->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Issue Date') ?></th>
                    <td><?= h($document->issue_date) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Name') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($document->name)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Badges') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($document->badges)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Certified') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($document->certified)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>