<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Faq $faq
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card shadow p-4">
                <div class="card-header bg-white text-dark rounded mb-3 d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">Add New FAQ</h3>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to FAQs',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <?= $this->Flash->render() ?>

                    <?php if ($faq->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($faq->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create($faq, ['class' => 'row g-3']) ?>

                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Question <span class="text-danger">*</span></label>
                            <?= $this->Form->control('question', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the question',
                                'required' => true,
                                'maxlength' => 255,
                                'id' => 'question'
                            ]) ?>
                            <div id="question-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Answer <span class="text-danger">*</span></label>
                            <?= $this->Form->control('answer', [
                                'class' => 'form-control',
                                'type' => 'textarea',
                                'rows' => 5,
                                'label' => false,
                                'placeholder' => 'Enter the answer',
                                'required' => true,
                                'maxlength' => 1000,
                                'id' => 'answer'
                            ]) ?>
                            <div id="answer-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/1000</div>
                        </div>
                    </div>

                    <div class="col-12 text-end d-flex justify-content-between">
                        <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                        <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Get references to form fields and counters
        const questionInput = document.getElementById('question');
        const answerInput = document.getElementById('answer');
        const questionCounter = document.getElementById('question-counter');
        const answerCounter = document.getElementById('answer-counter');

        // Validation functions
        function validateQuestion(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens, question marks
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-?]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateAnswer(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        // Update counter functions
        function updateQuestionCounter() {
            questionInput.value = validateQuestion(questionInput.value, 255);
            const charCount = questionInput.value.length;
            questionCounter.textContent = `Characters: ${charCount}/255${charCount === 255 ? ' (Maximum reached)' : ''}`;
            questionCounter.style.color = charCount === 255 ? 'red' : '#555';
        }

        function updateAnswerCounter() {
            answerInput.value = validateAnswer(answerInput.value, 1000);
            const charCount = answerInput.value.length;
            answerCounter.textContent = `Characters: ${charCount}/1000${charCount === 1000 ? ' (Maximum reached)' : ''}`;
            answerCounter.style.color = charCount === 1000 ? 'red' : '#555';
        }

        // Initialize counters on page load
        updateQuestionCounter();
        updateAnswerCounter();

        // Attach event listeners for real-time updates
        questionInput.addEventListener('input', updateQuestionCounter);
        answerInput.addEventListener('input', updateAnswerCounter);
    });
</script>
