<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Faq $faq
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit FAQ</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to FAQs',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete FAQ',
                            ['action' => 'delete', $faq->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $faq->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Flash->render() ?>

                    <?php if ($faq->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($faq->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create($faq, ['class' => 'row g-3']) ?>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="question">Question *</label>
                            <?= $this->Form->control('question', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the question',
                                'required' => true,
                                'maxlength' => 255,
                                'id' => 'question'
                            ]) ?>
                            <div id="question-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="answer">Answer *</label>
                            <?= $this->Form->control('answer', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the answer',
                                'rows' => 5,
                                'type' => 'textarea',
                                'required' => true,
                                'maxlength' => 1000,
                                'id' => 'answer'
                            ]) ?>
                            <div id="answer-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/1000</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Get references to input fields and counters
        const questionInput = document.getElementById('question');
        const answerInput = document.getElementById('answer');
        const questionCounter = document.getElementById('question-counter');
        const answerCounter = document.getElementById('answer-counter');

        // Validation functions
        function validateQuestion(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens, question marks
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-?]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateText(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens (same as certificate custom text)
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        // Update counter functions
        function updateQuestionCounter() {
            questionInput.value = validateQuestion(questionInput.value, 255);
            const charCount = questionInput.value.length;
            questionCounter.textContent = `Characters: ${charCount}/255${charCount === 255 ? ' (Maximum reached)' : ''}`;
            questionCounter.style.color = charCount === 255 ? 'red' : '#555';
        }

        function updateAnswerCounter() {
            answerInput.value = validateText(answerInput.value, 1000);
            const charCount = answerInput.value.length;
            answerCounter.textContent = `Characters: ${charCount}/1000${charCount === 1000 ? ' (Maximum reached)' : ''}`;
            answerCounter.style.color = charCount === 1000 ? 'red' : '#555';
        }

        // Initialize counters on page load
        updateQuestionCounter();
        updateAnswerCounter();

        // Attach event listeners for real-time updates
        questionInput.addEventListener('input', updateQuestionCounter);
        answerInput.addEventListener('input', updateAnswerCounter);
    });
</script>
