<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">FAQ Management</h5>
                    <?= $this->Html->link('New FAQ', ['action' => 'add'], ['class' => 'btn btn-primary ms-3']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('id') ?></th>
                                <th><?= $this->Paginator->sort('question') ?></th>
                                <th><?= $this->Paginator->sort('answer') ?></th>
                                <th><?= $this->Paginator->sort('created') ?></th>
                                <th><?= $this->Paginator->sort('modified') ?></th>
                               
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($faqs as $faq): ?>
                                <?php foreach ($faqs as $faq): ?>
                            <tr>
                                <td><?= $this->Number->format($faq->id) ?></td>
                        <td>
                            <?= $this->Html->link(
                                h($faq->question),
                                ['action' => 'edit', $faq->id],
                                ['class' => 'faq-link']
                            ) ?>
                        </td>
                        <td><?= h($faq->answer) ?></td>
                        <td><?= $faq->created->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                        <td><?= $faq->modified->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                    </tr>
                <?php endforeach; ?>

                            <?php endforeach; ?>
                        </tbody>

                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total') ?>


                            
                        </div>
                        <?= $this->Html->scriptBlock("
                            document.addEventListener('DOMContentLoaded', function() {
                                document.querySelectorAll('.clickable-row').forEach(row => {
                                    row.addEventListener('click', () => {
                                        window.location.href = row.dataset.href;
                                    });
                                });
                            });
                        ") ?>

                        <style>


                            .faq-link {
                                color:#e87532;
                                text-decoration: underline; /* ensures it's underlined */
                                font-weight: 500;
                            }

                            .clickable-row {
                                cursor: pointer;
                                transition: background-color 0.2s ease;
                            }

                            .clickable-row:hover {
                                background-color: #eaf4ff;
                            }

                            .clickable-row td {
                                color: #0d6efd;
                                text-decoration: underline;
                            }

                            .clickable-row:hover td {
                                color: #084298;
                            }
                            <style>
                            .faq-link {
                                color: #0d6efd;
                                text-decoration: underline;
                            }

                            .faq-link:hover {
                                color: #084298;
                            }

                          
                        </style>

                        </style>

                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
