<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramStatus $programStatus
 */
?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">


        <div class="row">
            <!-- Form Card -->
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Add Program Status</h5>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Program Statuses',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create($programStatus, ['class' => 'row g-3']) ?>

                        <!-- Status Name -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Status Name</label>
                                <?= $this->Form->control('name', [
                                    'required' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter status name',
                                    'id' => 'name'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="col-12">
                            <hr class="my-4">
                            <?= $this->Form->button(__('Create Status'), [
                                'class' => 'btn btn-primary me-2'
                            ]) ?>

                            <?= $this->Html->link(
                                __('Cancel'),
                                ['action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content-backdrop fade">
    </div>
</div>
