<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Program $program
 * @var \Cake\Collection\CollectionInterface|string[] $volunteers
 * */
?>

<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Add Volunteers to Program</h5>
                        <?= $this->Html->link('<i class="bx bx-arrow-back me-1"></i> Back to Program', ['action' => 'view', $program->id], ['class' => 'btn btn-secondary btn-sm', 'escape' => false]) ?>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create(null, ['url' => ['action' => 'addvolunteer', $program->id]]) ?>

                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="volunteers">Select Volunteers</label>
                                <?= $this->Form->control('volunteers._ids', [
                                    'type' => 'select',
                                    'options' => $volunteers,
                                    'multiple' => 'multiple',
                                    'label' => false,
                                    'class' => 'form-control',
                                    'id' => 'volunteers'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="col-12">
                            <?= $this->Form->button(__('Add Volunteers'), ['class' => 'btn btn-primary']) ?>
                            <?= $this->Html->link(__('Cancel'), ['action' => 'view', $program->id], ['class' => 'btn btn-outline-secondary']) ?>
                        </div>

                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
