<div class="container-xxl flex-grow-1 container-p-y">


    <div class="row">

        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Programs Images</h5>
                    <?= $this->Html->link(('New Programs Image'), ['action' => 'add'], ['class' => 'btn btn-primary']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <!--                                                <th>-->
                                <?php //= $this->Paginator->sort('id') ?><!--</th>-->
                                <th>Images</th>
                                <th><?= $this->Paginator->sort('program_id') ?></th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($programsImages as $programsImage): ?>
                                <tr>
                                    <!--                                                    <td>-->
                                    <?php //= $this->Number->format($programsImage->id) ?><!--</td>-->
                                    <td>
                                        <?php if (!empty($programsImage->image_name)): ?>
                                            <img
                                                src="<?= $this->Url->build('/' . $programsImage->image_name, ['fullBase' => true]) ?>"
                                                alt="Program Image"
                                                width="100" height="100">
                                        <?php else: ?>
                                            No Image
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($programsImage->hasValue('program')): ?>
                                            <span class="badge bg-label-primary">
                                                    <?= $this->Html->link(
                                                        $programsImage->program->name,
                                                        ['controller' => 'Programs', 'action' => 'view', $programsImage->program->id],
                                                        ['class' => 'text-decoration-none']
                                                    ) ?>
                                                </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="actions">
                                        <div class="dropdown">
                                            <button type="button"
                                                    class="btn p-0 dropdown-toggle hide-arrow"
                                                    data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
<!--                                                --><?php //= $this->Html->link(
//                                                    '<i class="bx bx-show-alt me-1"></i> View',
//                                                    ['action' => 'view', $programsImage->id],
//                                                    ['class' => 'dropdown-item', 'escape' => false]
//                                                ) ?>
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-edit-alt me-1"></i> Edit',
                                                    ['action' => 'edit', $programsImage->id],
                                                    ['class' => 'dropdown-item', 'escape' => false]
                                                ) ?>
                                                <?= $this->Form->postLink(
                                                    '<i class="bx bx-trash me-1"></i> Delete',
                                                    ['action' => 'delete', $programsImage->id],
                                                    [
                                                        'confirm' => __('Are you sure you want to delete # {0}?', $programsImage->id),
                                                        'class' => 'dropdown-item text-danger',
                                                        'escape' => false
                                                    ]
                                                ) ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                // Modify the default paginator to use Bootstrap classes
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
