<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsSection $programsSection
 * @var \Cake\Collection\CollectionInterface|string[] $programs
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Programs Sections'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="programsSections form content">
            <?= $this->Form->create($programsSection) ?>
            <fieldset>
                <legend><?= __('Add Programs Section') ?></legend>
                <?php
                    echo $this->Form->control('title');
                    echo $this->Form->control('body');
                    echo $this->Form->control('program_id', ['options' => $programs]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
