<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsSection $programsSection
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Programs Section'), ['action' => 'edit', $programsSection->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Programs Section'), ['action' => 'delete', $programsSection->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programsSection->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Programs Sections'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Programs Section'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="programsSections view content">
            <h3><?= h($programsSection->title) ?></h3>
            <table>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= h($programsSection->title) ?></td>
                </tr>
                <tr>
                    <th><?= __('Body') ?></th>
                    <td><?= h($programsSection->body) ?></td>
                </tr>
                <tr>
                    <th><?= __('Program') ?></th>
                    <td><?= $programsSection->hasValue('program') ? $this->Html->link($programsSection->program->name, ['controller' => 'Programs', 'action' => 'view', $programsSection->program->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($programsSection->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>