<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ProgramsVolunteer> $programsVolunteers
 */
?>
<div class="programsVolunteers index content">
    <?= $this->Html->link(__('New Programs Volunteer'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Programs Volunteers') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('program_id') ?></th>
                    <th><?= $this->Paginator->sort('volunteer_id') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($programsVolunteers as $programsVolunteer): ?>
                <tr>
                    <td><?= $this->Number->format($programsVolunteer->id) ?></td>
                    <td><?= $programsVolunteer->hasValue('program') ? $this->Html->link($programsVolunteer->program->name, ['controller' => 'Programs', 'action' => 'view', $programsVolunteer->program->id]) : '' ?></td>
                    <td><?= $programsVolunteer->hasValue('volunteer') ? $this->Html->link($programsVolunteer->volunteer->first_name, ['controller' => 'Volunteers', 'action' => 'view', $programsVolunteer->volunteer->id]) : '' ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $programsVolunteer->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $programsVolunteer->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $programsVolunteer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programsVolunteer->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>