<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title>Student Registration</title>
    <?= $this->Html->css('vendor/bootstrap/css/bootstrap.min.css', ['pathPrefix' => 'assets/']) ?>
    <?= $this->Html->css('vendor/bootstrap-icons/bootstrap-icons.css', ['pathPrefix' => 'assets/']) ?>
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        /* PRIMARY BRAND COLOR: #e87532 and #d7682c for gradients/hover states */
        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        }
        .card-header.bg-primary.text-white.rounded.mb-3 h3 {
            color: #fff !important;
        }
        .card-header.bg-primary.text-white.rounded.mb-3 {
            color: #fff !important;
            background: linear-gradient(45deg, #e87532, #d7682c) !important;
            border: none !important;
            border-radius: 0.8rem !important;
        }
        .card-header h3 {
            font-weight: 700;
            letter-spacing: 1px;
        }
        .btn-primary {
            background: linear-gradient(45deg, #e87532, #d7682c);
            border: none;
            border-radius: 0.8rem;
            font-weight: 600;
            padding: 0.6rem 1.5rem;
        }
        .btn-primary:hover,
        .btn-primary:focus {
            background: linear-gradient(45deg, #d7682c, #c65e28);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        .btn-secondary {
            background: linear-gradient(45deg, #d3d3d3, #a9a9a9);
            border: none;
            border-radius: 0.8rem;
            font-weight: 600;
            padding: 0.6rem 1.5rem;
        }
        .btn-secondary:hover,
        .btn-secondary:focus {
            background: linear-gradient(45deg, #808080, #696969);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        .form-label {
            font-weight: 600;
        }
        .student-form {
            background: var(--surface-color);
            border: 1px solid #eee;
            border-radius: 0.8rem;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        .form-header {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 1.125rem;
            font-weight: 700;
            background-color: #fafafa;
            border-bottom: 1px solid #eee;
            padding: 0.625rem 0.9375rem;
            border-top-left-radius: 0.8rem;
            border-top-right-radius: 0.8rem;
            transition: background-color 0.3s ease;
        }
        .form-header:hover {
            background-color: #f0f0f0;
        }
        .icon-group {
            display: flex;
            gap: 0.625rem;
        }
        .icon-group i {
            font-size: 1.25rem;
            color: #e87532;
            cursor: pointer;
            transition: color 0.3s ease, transform 0.3s ease;
        }
        .icon-group i:hover {
            color: #d7682c;
            transform: scale(1.1);
        }
        .arrow {
            color: #e87532;
            font-size: 1.25rem;
            transition: transform 0.3s ease, color 0.3s ease;
            margin-right: 0.5rem;
        }
        .form-header:hover .arrow {
            color: #d7682c;
        }
        .form-content {
            padding-top: 0.75rem;
        }
        #programsTable {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 14px;
        }
        #programsTable .program-row {
            cursor: pointer;
            background-color: white;
            transition: background-color 0.3s ease;
        }
        #programsTable .program-row:hover {
            background-color: #f1f1f1;
        }
        #programsTable .program-row.selected {
            background-color: #007bff;
            color: white;
        }
        #programsTable .program-row.selected:hover {
            background-color: #0056b3;
        }
        #programsTable thead {
            background-color: #007bff;
            color: #fff;
        }
        #programsTable th {
            padding: 12px;
            text-align: left;
        }
        #programsTable td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        #programsTable-wrapper {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #ddd;
        }
        #programsTable {
            border: 1px solid #ddd;
        }
        #programsTable .program-row {
            border-bottom: 1px solid #ddd;
        }
        .validation-message {
            margin-top: 5px;
            font-size: 0.9rem;
            color: #555;
        }
        .validation-message.error {
            color: red;
        }
    </style>
</head>
<body class="index-page">

<section id="student-registration" class="py-5">
    <div class="container">
        <div class="card shadow p-4">
            <div class="card-header bg-primary text-white rounded mb-3">
                <h3 class="mb-0">Student Registration Form</h3>
            </div>

            <div class="card-body">
                <?= $this->Flash->render() ?>
                <?php if ($student->getErrors()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php foreach ($student->getErrors() as $field => $errors): ?>
                                <?php foreach ($errors as $error): ?>
                                    <li><?= h($error) ?></li>
                                <?php endforeach; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?= $this->Form->create(null, [
                    'url' => ['controller' => 'Students', 'action' => 'add'],
                    'id' => 'registration-form'
                ]) ?>

                <!-- Registrar Information -->
                <fieldset class="mb-4">
                    <legend>Registrar Information</legend>
                    <div class="mb-3">
                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_name', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your full name',
                            'label' => false,
                            'required' => true,
                            'pattern' => '^[A-Za-z\s-]+$',
                            'title' => 'Only letters, spaces, and hyphens are allowed',
                            'maxlength' => '100',
                            'id' => 'contact-name'
                        ]) ?>
                        <div id="contact-name-counter" class="validation-message">Characters: 0/100</div>
                        <div id="contact-name-message" class="validation-message"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_email', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your email',
                            'label' => false,
                            'required' => true,
                            'type' => 'email',
                            'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                            'title' => 'Enter a valid email address',
                            'maxlength' => '50',
                            'id' => 'contact-email'
                        ]) ?>
                        <div id="contact-email-counter" class="validation-message">Characters: 0/50</div>
                        <div id="contact-email-message" class="validation-message"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_phone', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your phone number',
                            'label' => false,
                            'required' => true,
                            'pattern' => '^[0-9]{10}$',
                            'title' => 'Phone number must be exactly 10 digits',
                            'maxlength' => '10',
                            'id' => 'contact-phone'
                        ]) ?>
                        <div id="contact-phone-counter" class="validation-message">Characters: 0/10</div>
                        <div id="contact-phone-message" class="validation-message"></div>
                    </div>
                </fieldset>

                <!-- Student Details -->
                <fieldset class="mb-4">
                    <legend>Student Details</legend>
                    <div id="studentFormsContainer"></div>
                </fieldset>

                <div class="text-end d-flex justify-content-between">
                    <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                    <?= $this->Form->button('Submit', ['class' => 'btn btn-primary']) ?>
                </div>
                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
</section>

<!-- Hidden Student Form Template -->
<div id="studentFormTemplate" style="display: none;">
    <div class="student-form mb-3">
        <div class="form-header" onclick="toggleForm(this)">
            <div class="d-flex align-items-center">
                <strong>
                    <span class="arrow">▼</span> Student Details
                </strong>
            </div>
            <div class="icon-group">
                <i class="bi bi-plus plus-icon" onclick="event.stopPropagation(); addStudentForm();"></i>
                <i class="bi bi-trash delete-icon" onclick="event.stopPropagation(); deleteStudentForm(this);"></i>
            </div>
        </div>
        <div class="form-content mt-3 px-3">
            <div class="mb-3">
                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                <input type="text" name="name[]" class="form-control student-name" placeholder="Enter full name" required pattern="^[A-Za-z\s-]+$" title="Only letters, spaces, and hyphens are allowed" maxlength="100">
                <div class="name-counter validation-message">Characters: 0/100</div>
                <div class="name-message validation-message"></div>
            </div>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Year Level <span class="text-danger">*</span></label>
                    <input type="text" name="year[]" class="form-control student-year" placeholder="Enter year level" required pattern="^[A-Za-z0-9\s]+$" title="Letters, numbers and spaces only" maxlength="25">
                    <div class="year-counter validation-message">Characters: 0/25</div>
                    <div class="year-message validation-message"></div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">School <span class="text-danger">*</span></label>
                    <input type="text" name="school[]" class="form-control student-school" placeholder="Enter School" required pattern="^[A-Za-z\s]+$" title="Only letters and spaces are allowed" maxlength="100">
                    <div class="school-counter validation-message">Characters: 0/100</div>
                    <div class="school-message validation-message"></div>
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label">Programs <span class="text-danger">*</span></label>
                <div id="programsTable-wrapper">
                    <table id="programsTable">
                        <tbody>
                        <?php foreach ($programs as $program_id => $program_name): ?>
                            <tr data-program-id="<?= h($program_id) ?>" class="program-row">
                                <td>
                                    <input type="checkbox" name="programs" value="<?= h($program_id) ?>" class="program-checkbox">
                                    <?= h($program_name) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <div class="programs-message validation-message"></div>
                <input type="hidden" name="programsData[]" class="programs-data">
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const container = document.getElementById('studentFormsContainer');
        const template = document.getElementById('studentFormTemplate').firstElementChild;
        const contactNameInput = document.getElementById('contact-name');
        const contactEmailInput = document.getElementById('contact-email');
        const contactPhoneInput = document.getElementById('contact-phone');
        const contactNameCounter = document.getElementById('contact-name-counter');
        const contactEmailCounter = document.getElementById('contact-email-counter');
        const contactPhoneCounter = document.getElementById('contact-phone-counter');
        const contactNameMessage = document.getElementById('contact-name-message');
        const contactEmailMessage = document.getElementById('contact-email-message');
        const contactPhoneMessage = document.getElementById('contact-phone-message');
        let studentIndex = 0;
        let formSubmitted = false;

        // Validation functions
        function validateText(input, pattern, maxLength, title) {
            if (!input) return { valid: false, message: `${title} is required` };
            let sanitized = input.replace(new RegExp(pattern.replace('^', '').replace('$', ''), 'g'), '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            if (!new RegExp(pattern).test(sanitized)) {
                return { valid: false, message: title };
            }
            return { valid: true, message: '' };
        }

        function validateEmail(email) {
            if (!email) return { valid: false, message: 'Email is required' };
            const pattern = '[^@ \\t\\r\\n]+@[^@ \\t\\r\\n]+\\.[^@ \\t\\r\\n]+';
            if (!new RegExp(`^${pattern}$`).test(email)) {
                return { valid: false, message: 'Enter a valid email address' };
            }
            return { valid: true, message: '' };
        }

        function validatePrograms(studentForm) {
            const checkboxes = studentForm.querySelectorAll('.program-checkbox');
            const selected = Array.from(checkboxes).some(cbox => cbox.checked);
            return { valid: selected, message: selected ? '' : 'At least one program must be selected' };
        }

        // Update counter and feedback functions
        function updateContactNameFeedback() {
            const result = validateText(contactNameInput.value, "^[A-Za-z\\s-]+$", 100, "Only letters, spaces, and hyphens are allowed");
            contactNameInput.value = result.valid ? contactNameInput.value : contactNameInput.value.replace(/[^A-Za-z\s-]/g, '');
            contactNameMessage.textContent = result.message;
            contactNameMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            contactNameInput.setCustomValidity(result.valid ? '' : result.message);
            contactNameCounter.textContent = `Characters: ${contactNameInput.value.length}/100${contactNameInput.value.length === 100 ? ' (Maximum reached)' : ''}`;
            contactNameCounter.style.color = contactNameInput.value.length === 100 ? 'red' : '#555';
        }

        function updateContactEmailFeedback() {
            const result = validateEmail(contactEmailInput.value);
            contactEmailMessage.textContent = result.message;
            contactEmailMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            contactEmailInput.setCustomValidity(result.valid ? '' : result.message);
            contactEmailCounter.textContent = `Characters: ${contactEmailInput.value.length}/50${contactEmailInput.value.length === 50 ? ' (Maximum reached)' : ''}`;
            contactEmailCounter.style.color = contactEmailInput.value.length === 50 ? 'red' : '#555';
        }

        function updateContactPhoneFeedback() {
            const result = validateText(contactPhoneInput.value, "^[0-9]{10}$", 10, "Phone number must be exactly 10 digits");
            contactPhoneInput.value = result.valid ? contactPhoneInput.value : contactPhoneInput.value.replace(/[^0-9]/g, '').substring(0, 10);
            contactPhoneMessage.textContent = result.message;
            contactPhoneMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            contactPhoneInput.setCustomValidity(result.valid ? '' : result.message);
            contactPhoneCounter.textContent = `Characters: ${contactPhoneInput.value.length}/10${contactPhoneInput.value.length === 10 ? ' (Maximum reached)' : ''}`;
            contactPhoneCounter.style.color = contactPhoneInput.value.length === 10 ? 'red' : '#555';
        }

        function updateStudentFormFeedback(studentForm) {
            const nameInput = studentForm.querySelector('.student-name');
            const yearInput = studentForm.querySelector('.student-year');
            const schoolInput = studentForm.querySelector('.student-school');
            const nameCounter = studentForm.querySelector('.name-counter');
            const yearCounter = studentForm.querySelector('.year-counter');
            const schoolCounter = studentForm.querySelector('.school-counter');
            const nameMessage = studentForm.querySelector('.name-message');
            const yearMessage = studentForm.querySelector('.year-message');
            const schoolMessage = studentForm.querySelector('.school-message');
            const programsMessage = studentForm.querySelector('.programs-message');

            // Name validation
            const nameResult = validateText(nameInput.value, "^[A-Za-z\\s-]+$", 100, "Only letters, spaces, and hyphens are allowed");
            nameInput.value = nameResult.valid ? nameInput.value : nameInput.value.replace(/[^A-Za-z\s-]/g, '');
            nameMessage.textContent = nameResult.message;
            nameMessage.className = 'validation-message' + (formSubmitted && !nameResult.valid ? ' error' : '');
            nameInput.setCustomValidity(nameResult.valid ? '' : nameResult.message);
            nameCounter.textContent = `Characters: ${nameInput.value.length}/100${nameInput.value.length === 100 ? ' (Maximum reached)' : ''}`;
            nameCounter.style.color = nameInput.value.length === 100 ? 'red' : '#555';

            // Year validation
            const yearResult = validateText(yearInput.value, "^[A-Za-z0-9\\s]+$", 25, "Letters, numbers and spaces only");
            yearInput.value = yearResult.valid ? yearInput.value : yearInput.value.replace(/[^A-Za-z0-9\s]/g, '');
            yearMessage.textContent = yearResult.message;
            yearMessage.className = 'validation-message' + (formSubmitted && !yearResult.valid ? ' error' : '');
            yearInput.setCustomValidity(yearResult.valid ? '' : yearResult.message);
            yearCounter.textContent = `Characters: ${yearInput.value.length}/25${yearInput.value.length === 25 ? ' (Maximum reached)' : ''}`;
            yearCounter.style.color = yearInput.value.length === 25 ? 'red' : '#555';

            // School validation
            const schoolResult = validateText(schoolInput.value, "^[A-Za-z\\s]+$", 100, "Only letters and spaces are allowed");
            schoolInput.value = schoolResult.valid ? schoolInput.value : schoolInput.value.replace(/[^A-Za-z\s]/g, '');
            schoolMessage.textContent = schoolResult.message;
            schoolMessage.className = 'validation-message' + (formSubmitted && !schoolResult.valid ? ' error' : '');
            schoolInput.setCustomValidity(schoolResult.valid ? '' : schoolResult.message);
            schoolCounter.textContent = `Characters: ${schoolInput.value.length}/100${schoolInput.value.length === 100 ? ' (Maximum reached)' : ''}`;
            schoolCounter.style.color = schoolInput.value.length === 100 ? 'red' : '#555';

            // Programs validation
            const programsResult = validatePrograms(studentForm);
            programsMessage.textContent = programsResult.message;
            programsMessage.className = 'validation-message' + (formSubmitted && !programsResult.valid ? ' error' : '');
        }

        function addStudentForm() {
            const clone = template.cloneNode(true);
            clone.style.display = 'block';
            document.querySelectorAll('.form-content').forEach(c => c.style.display = 'none');
            clone.querySelector('.form-content').style.display = 'block';
            const hiddenInput = clone.querySelector('.programs-data');
            hiddenInput.name = `programsData[${studentIndex}][]`;
            container.appendChild(clone);

            // Add event listeners
            const nameInput = clone.querySelector('.student-name');
            const yearInput = clone.querySelector('.student-year');
            const schoolInput = clone.querySelector('.student-school');
            const checkboxes = clone.querySelectorAll('.program-checkbox');

            nameInput.addEventListener('input', () => updateStudentFormFeedback(clone));
            yearInput.addEventListener('input', () => updateStudentFormFeedback(clone));
            schoolInput.addEventListener('input', () => updateStudentFormFeedback(clone));
            checkboxes.forEach(cbox => {
                cbox.addEventListener('change', () => {
                    updateProgramsData(clone);
                    updateStudentFormFeedback(clone);
                });
            });

            updateStudentFormFeedback(clone);
            studentIndex++;
        }

        function deleteStudentForm(icon) {
            const studentForm = icon.closest('.student-form');
            const forms = document.querySelectorAll('#studentFormsContainer .student-form');
            if (forms.length === 1) {
                alert("At least one student detail must remain.");
                return;
            }
            studentForm.remove();
        }

        function toggleForm(header) {
            const content = header.nextElementSibling;
            const arrow = header.querySelector('.arrow');
            document.querySelectorAll('.form-content').forEach(c => {
                if (c !== content) c.style.display = 'none';
            });
            content.style.display = (content.style.display === 'block') ? 'none' : 'block';
            arrow.textContent = (content.style.display === 'block') ? '▲' : '▼';
        }

        function updateProgramsData(studentForm) {
            const checkboxes = studentForm.querySelectorAll('.program-checkbox');
            const hiddenField = studentForm.querySelector('.programs-data');
            const selectedPrograms = [];
            checkboxes.forEach(cbox => {
                if (cbox.checked) {
                    selectedPrograms.push(parseInt(cbox.value, 10));
                }
            });
            hiddenField.value = JSON.stringify(selectedPrograms);
        }

        // Initialize validation
        updateContactNameFeedback();
        updateContactEmailFeedback();
        updateContactPhoneFeedback();

        // Add first student form
        addStudentForm();

        // Form submission validation
        const form = document.getElementById('registration-form');
        form.addEventListener('submit', function(e) {
            formSubmitted = true;
            updateContactNameFeedback();
            updateContactEmailFeedback();
            updateContactPhoneFeedback();
            const studentForms = document.querySelectorAll('.student-form');
            studentForms.forEach(form => updateStudentFormFeedback(form));

            const isValid = (
                validateText(contactNameInput.value, "^[A-Za-z\\s-]+$", 100, "Only letters, spaces, and hyphens are allowed").valid &&
                validateEmail(contactEmailInput.value).valid &&
                validateText(contactPhoneInput.value, "^[0-9]{10}$", 10, "Phone number must be exactly 10 digits").valid &&
                Array.from(studentForms).every(form => {
                    const nameResult = validateText(form.querySelector('.student-name').value, "^[A-Za-z\\s-]+$", 100, "Only letters, spaces, and hyphens are allowed");
                    const yearResult = validateText(form.querySelector('.student-year').value, "^[A-Za-z0-9\\s]+$", 25, "Letters, numbers and spaces only");
                    const schoolResult = validateText(form.querySelector('.student-school').value, "^[A-Za-z\\s]+$", 100, "Only letters and spaces are allowed");
                    const programsResult = validatePrograms(form);
                    return nameResult.valid && yearResult.valid && schoolResult.valid && programsResult.valid;
                })
            );

            if (!isValid) {
                e.preventDefault();
                contactNameInput.reportValidity();
                contactEmailInput.reportValidity();
                contactPhoneInput.reportValidity();
                studentForms.forEach(form => {
                    form.querySelector('.student-name').reportValidity();
                    form.querySelector('.student-year').reportValidity();
                    form.querySelector('.student-school').reportValidity();
                });
            }
        });
    });
</script>

<?= $this->Html->script('vendor/bootstrap/js/bootstrap.bundle.min.js', ['pathPrefix' => 'assets/']) ?>
</body>
</html>
