<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Student> $students
 * @var string|null $start
 * @var string|null $end
 */
?>
<div class="container-xxl flex-grow-2 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <?= $this->Form->create(null, [
                        'url' => ['action' => 'overview'],
                        'type' => 'get',
                        'class' => 'd-flex gap-3'
                    ]) ?>
                    <?= $this->Form->control('start_date', [
                        'type' => 'date',
                        'label' => false,
                        'value' => $start,
                        'class' => 'form-control'
                    ]) ?>
                    <?= $this->Form->control('end_date', [
                        'type' => 'date',
                        'label' => false,
                        'value' => $end,
                        'class' => 'form-control'
                    ]) ?>
                    <?= $this->Form->button(__('Filter'), ['class' => 'btn btn-outline-primary']) ?>
                    <?= $this->Form->end() ?>
                    <div>
                        <?= $this->Html->link(
                            __('Back to Students'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            'Preview CSV',
                            ['action' => 'preview', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-info me-2']
                        ) ?>
                        <?= $this->Html->link(
                            __('New Student'),
                            ['action' => 'add'],
                            ['class' => 'btn btn-primary']
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('name', 'Name') ?></th>
                                <th><?= $this->Paginator->sort('year_level', 'Year Level') ?></th>
                                <th><?= $this->Paginator->sort('school', 'School') ?></th>
                                <th><?= $this->Paginator->sort('contact_name', 'Contact Name') ?></th>
                                <th><?= $this->Paginator->sort('contact_phone', 'Contact Phone') ?></th>
                                <th><?= $this->Paginator->sort('registration_date', 'Registration Date') ?></th>
                                <th><?= $this->Paginator->sort('contact_email', 'Contact Email') ?></th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($students as $student): ?>
                                <tr>
                                    <td><?= h($student->name) ?></td>
                                    <td><?= h($student->year_level) ?></td>
                                    <td><?= h($student->school) ?></td>
                                    <td><?= h($student->contact_name) ?></td>
                                    <td><?= h($student->contact_phone) ?></td>
                                    <td><?= $student->registration_date?->format('Y-m-d') ?></td>
                                    <td><?= h($student->contact_email) ?></td>
                                    <td class="actions">
                                        <?= $this->Html->link('View', ['action' => 'view', $student->id], ['class' => 'btn btn-sm btn-outline-secondary']) ?>
                                        <?= $this->Html->link('Edit', ['action' => 'edit', $student->id], ['class' => 'btn btn-sm btn-outline-primary']) ?>
                                        <?= $this->Form->postLink('Delete', ['action' => 'delete', $student->id], [
                                            'confirm' => __('Are you sure you want to delete # {0}?', $student->id),
                                            'class' => 'btn btn-sm btn-outline-danger'
                                        ]) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-4">
                        <ul class="pagination justify-content-center">
                            <?= $this->Paginator->first('', [
                                'class' => 'page-item',
                                'escape' => false,
                                'template' => '<li class="page-item"><a class="page-link">{{text}}</a></li>'
                            ]) ?>
                            <?= $this->Paginator->prev('', ['class' => 'page-item', 'escape' => false]) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next('', ['class' => 'page-item', 'escape' => false]) ?>
                            <?= $this->Paginator->last('', ['class' => 'page-item', 'escape' => false]) ?>
                        </ul>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter() ?>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
