
<style>
    .card-body .flex-container {
        position: relative;
        display: flex;
        gap: 1rem;
        flex-direction: column;
    }

    .table-responsive {
        flex: 1 1 auto;
        max-height: 60vh;
        overflow-y: auto;
    }

    .card-header {
        position: sticky;
        top: 0;
        background: #fff;
        z-index: 5;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .table-striped tbody tr.active {
        background: #f0f8ff;
    }

    #template-search {
        width: 100%;
        padding: 0.5rem;
        margin-bottom: 1rem;
        font-size: 1rem;
        border: 1px solid #ddd;
        border-radius: 0.25rem;
    }

    .btn-outline-primary:focus,
    .btn-outline-secondary:focus {
        outline: 2px solid #E87532;
        outline-offset: 2px;
    }
</style>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Manage Email Templates</h5>
                    <?= $this->Html->link('Create New Template',
                        ['action'=>'create'],
                        ['class'=>'btn btn-primary']) ?>
                </div>

                <div class="card-body">
                    <div class="flex-container">
                        <div class="table-responsive text-nowrap">
                            <input type="text" id="template-search" placeholder="🔍 Search templates…" />

                            <table class="table table-striped table-hover">
                                <thead>
                                <tr>
                                    <th>#</th><th>Name</th><th>Send</th><th>Delete</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i = 1; ?>
                                <?php foreach ($templates as $template): ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td>
                                            <?= $this->Html->link(h($template->name),
                                                ['action'=>'view',$template->id],
                                                [
                                                    'class'=>'text-primary fw-semibold text-decoration-none'
                                                ]) ?>
                                        </td>
                                        <td>
                                            <?= $this->Html->link('<i class="bx bx-window-open"></i>',
                                                ['action'=>'view',$template->id],
                                                [
                                                    'escape'=>false,
                                                    'class'=>'btn btn-sm btn-outline-primary',
                                                    'title'=>'Open full view'
                                                ]) ?>
                                        </td>
                                        <td>
                                            <?= $this->Form->postLink('<i class="bx bx-trash"></i>',
                                                ['action'=>'delete',$template->id],
                                                [
                                                    'confirm'=>'Are you sure?',
                                                    'escape'=>false,
                                                    'class'=>'btn btn-sm btn-outline-danger'
                                                ]) ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        document.getElementById('template-search')
            .addEventListener('input', e => {
                const term = e.target.value.toLowerCase();
                document.querySelectorAll('tbody tr').forEach(tr => {
                    const name = tr.children[1].textContent.toLowerCase();
                    tr.style.display = name.includes(term) ? '' : 'none';
                });
            });
    });
</script>