<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Visitor $visitor
 */
?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Edit Visitor</h5>
                        <div>
                            <?= $this->Html->link(
                                '<i class="bx bx-arrow-back me-1"></i> Back to Visitors',
                                ['action' => 'index'],
                                ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                            ) ?>
                            <?= $this->Form->postLink(
                                '<i class="bx bx-trash me-1"></i> Delete Visitor',
                                ['action' => 'delete', $visitor->id],
                                [
                                    'confirm' => __('Are you sure you want to delete # {0}?', $visitor->id),
                                    'class' => 'btn btn-danger btn-sm ms-2',
                                    'escape' => false
                                ]
                            ) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create($visitor, ['class' => 'row g-3']) ?>

                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Name <span class="text-danger">*</span></label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter name',
                                    'id' => 'name',
                                    'required' => true,
                                    'maxlength' => 255
                                ]) ?>
                                <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="email">Email <span class="text-danger">*</span></label>
                                <?= $this->Form->control('email', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter email',
                                    'id' => 'email',
                                    'required' => true,
                                    'maxlength' => 255
                                ]) ?>
                                <div id="email-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                                <div id="email-message" style="margin-top: 5px; font-size: 0.9rem; color: #555;"></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="created-at">Created At</label>
                                <?= $this->Form->control('created_at', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'created-at',
                                    'empty' => true,
                                    'disabled' => true
                                ]) ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="updated-at">Updated At</label>
                                <?= $this->Form->control('updated_at', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'updated-at',
                                    'empty' => true,
                                    'disabled' => true
                                ]) ?>
                            </div>
                        </div>

                        <div class="col-12">
                            <hr class="my-4">
                            <?= $this->Form->button(__('Save Changes'), [
                                'class' => 'btn btn-primary me-2'
                            ]) ?>
                            <?= $this->Html->link(
                                __('Cancel'),
                                ['action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>

                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Get references to form fields and feedback elements
        const nameInput = document.getElementById('name');
        const emailInput = document.getElementById('email');
        const nameCounter = document.getElementById('name-counter');
        const emailCounter = document.getElementById('email-counter');
        const emailMessage = document.getElementById('email-message');

        // Validation functions
        function validateName(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateEmail(input, maxLength) {
            // Allow standard email characters (letters, numbers, @, dots, etc.)
            let sanitized = input.replace(/[^a-zA-Z0-9@._-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return { sanitized, isValidFormat: emailPattern.test(sanitized) };
        }

        // Update counter and feedback functions
        function updateNameCounter() {
            nameInput.value = validateName(nameInput.value, 255);
            const charCount = nameInput.value.length;
            nameCounter.textContent = `Characters: ${charCount}/255${charCount === 255 ? ' (Maximum reached)' : ''}`;
            nameCounter.style.color = charCount === 255 ? 'red' : '#555';
        }

        function updateEmailFeedback() {
            const result = validateEmail(emailInput.value, 255);
            emailInput.value = result.sanitized;
            const charCount = emailInput.value.length;
            emailCounter.textContent = `Characters: ${charCount}/255${charCount === 255 ? ' (Maximum reached)' : ''}`;
            emailCounter.style.color = charCount === 255 ? 'red' : '#555';
            if (!result.isValidFormat && emailInput.value) {
                emailMessage.textContent = 'Please enter a valid email address';
                emailMessage.style.color = 'red';
                emailInput.setCustomValidity('Invalid email format');
            } else {
                emailMessage.textContent = '';
                emailInput.setCustomValidity('');
            }
        }

        // Initialize validation on page load
        updateNameCounter();
        updateEmailFeedback();

        // Attach event listeners for real-time updates
        nameInput.addEventListener('input', updateNameCounter);
        emailInput.addEventListener('input', updateEmailFeedback);

        // Prevent form submission if validation fails
        const form = document.querySelector('form');
        form.addEventListener('submit', function(e) {
            updateEmailFeedback();
            if (emailInput.getCustomValidity() !== '') {
                e.preventDefault();
                emailInput.reportValidity();
            }
        });
    });
</script>
