<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 * @var \Cake\Collection\CollectionInterface|string[] $volunteerStatuses
 * @var \Cake\Collection\CollectionInterface|string[] $programs
 */
?>
<style>
    .validation-message {
        margin-top: 5px;
        font-size: 0.9rem;
        color: #555;
    }
    .validation-message.error {
        color: red;
    }
</style>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Add Volunteer</h5>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Volunteers',
                        ['action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                    ) ?>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($volunteer, ['class' => 'row g-3']) ?>

                    <!-- First Name -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="first-name">First Name <span class="text-danger">*</span></label>
                            <?= $this->Form->control('first_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter first name',
                                'id' => 'first-name',
                                'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => 15
                            ]) ?>
                            <div id="first-name-counter" class="validation-message">Characters: 0/100</div>
                            <div id="first-name-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Last Name -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="last-name">Last Name <span class="text-danger">*</span></label>
                            <?= $this->Form->control('last_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter last name',
                                'id' => 'last-name',
                                'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => 15
                            ]) ?>
                            <div id="last-name-counter" class="validation-message">Characters: 0/100</div>
                            <div id="last-name-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="email">Email Address <span class="text-danger">*</span></label>
                            <?= $this->Form->control('email', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter email address',
                                'type' => 'email',
                                'id' => 'email',
                                'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                                'title' => 'Enter a valid email address',
                                'maxlength' => 255
                            ]) ?>
                            <div id="email-counter" class="validation-message">Characters: 0/255</div>
                            <div id="email-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Phone -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="phone">Phone Number</label>
                            <?= $this->Form->control('phone', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter phone number',
                                'id' => 'phone',
                                'pattern' => '^[0-9]{10}$',
                                'title' => 'Phone number must be exactly 10 digits',
                                'maxlength' => 10
                            ]) ?>
                            <div id="phone-counter" class="validation-message">Characters: 0/10</div>
                            <div id="phone-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Postcode -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="postcode">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter postcode',
                                'id' => 'postcode',
                                'pattern' => '^[0-9]{4,}$',
                                'title' => 'Postcode must be at least 4 digits',
                                'maxlength' => 10
                            ]) ?>
                            <div id="postcode-counter" class="validation-message">Characters: 0/10</div>
                            <div id="postcode-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Occupation -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="occupation">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter occupation',
                                'id' => 'occupation',
                                'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => 100
                            ]) ?>
                            <div id="occupation-counter" class="validation-message">Characters: 0/100</div>
                            <div id="occupation-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="description">Description</label>
                            <?= $this->Form->control('description', [
                                'type' => 'textarea',
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter additional information about the volunteer',
                                'rows' => 4,
                                'id' => 'description',
                                'required' => false
                            ]) ?>
                            <div id="description-counter" class="validation-message">Words: 0/50</div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="volunteer-status">Volunteer Status</label>
                            <?= $this->Form->control('volunteer_status_id', [
                                'options' => $volunteerStatuses,
                                'empty' => '-- Select Status --',
                                'class' => 'form-select',
                                'label' => false,
                                'id' => 'volunteer-status',
                                'required' => false
                            ]) ?>
                            <div id="volunteer-status-message" class="validation-message"></div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Create Volunteer'), ['class' => 'btn btn-primary me-2']) ?>
                        <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-outline-secondary']) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get references to form fields and feedback elements
        const firstNameInput = document.getElementById('first-name');
        const lastNameInput = document.getElementById('last-name');
        const emailInput = document.getElementById('email');
        const phoneInput = document.getElementById('phone');
        const postcodeInput = document.getElementById('postcode');
        const occupationInput = document.getElementById('occupation');
        const descriptionInput = document.getElementById('description');
        const statusInput = document.getElementById('volunteer-status');
        const firstNameCounter = document.getElementById('first-name-counter');
        const lastNameCounter = document.getElementById('last-name-counter');
        const emailCounter = document.getElementById('email-counter');
        const phoneCounter = document.getElementById('phone-counter');
        const postcodeCounter = document.getElementById('postcode-counter');
        const occupationCounter = document.getElementById('occupation-counter');
        const descriptionCounter = document.getElementById('description-counter');
        const firstNameMessage = document.getElementById('first-name-message');
        const lastNameMessage = document.getElementById('last-name-message');
        const emailMessage = document.getElementById('email-message');
        const phoneMessage = document.getElementById('phone-message');
        const postcodeMessage = document.getElementById('postcode-message');
        const occupationMessage = document.getElementById('occupation-message');
        const statusMessage = document.getElementById('volunteer-status-message');
        let formSubmitted = false;

        // Validation functions
        function validateText(input, pattern, maxLength, title, allowEmpty = false) {
            if (allowEmpty && !input) return { valid: true, message: '' };
            let sanitized = input.replace(new RegExp(pattern.replace('^', '').replace('$', ''), 'g'), '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            if (!new RegExp(pattern).test(sanitized) && sanitized !== '') {
                return { valid: false, message: title };
            }
            return { valid: true, message: '' };
        }

        function validateEmail(email) {
            if (!email) return { valid: false, message: 'Email is required' };
            const pattern = '[^@ \\t\\r\\n]+@[^@ \\t\\r\\n]+\\.[^@ \\t\\r\\n]+';
            if (!new RegExp(`^${pattern}$`).test(email)) {
                return { valid: false, message: 'Enter a valid email address' };
            }
            return { valid: true, message: '' };
        }

        function validateRequiredText(input, maxLength, title) {
            if (!input) return { valid: false, message: title };
            if (input.length > maxLength) {
                return { valid: false, message: `Must be ${maxLength} characters or less` };
            }
            return { valid: true, message: '' };
        }

        // Update counter and feedback functions
        function updateFirstNameFeedback() {
            const result = validateRequiredText(firstNameInput.value, 15, 'First name is required');
            if (result.valid && firstNameInput.value) {
                const patternResult = validateText(firstNameInput.value, "^[A-Za-z\s'-]+$", 15, "Only letters, spaces, apostrophes and dashes are allowed");
                firstNameInput.value = patternResult.valid ? firstNameInput.value : firstNameInput.value.replace(/[^A-Za-z\s'-]/g, '').substring(0, 15);
                firstNameMessage.textContent = patternResult.message;
                firstNameMessage.className = 'validation-message' + (formSubmitted && !patternResult.valid ? ' error' : '');
                firstNameInput.setCustomValidity(patternResult.valid ? '' : patternResult.message);
            } else {
                firstNameMessage.textContent = result.message;
                firstNameMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
                firstNameInput.setCustomValidity(result.message);
            }
            firstNameCounter.textContent = `Characters: ${firstNameInput.value.length}/15${firstNameInput.value.length === 15 ? ' (Maximum reached)' : ''}`;
            firstNameCounter.style.color = firstNameInput.value.length === 15 ? 'red' : '#555';
        }

        function updateLastNameFeedback() {
            const result = validateRequiredText(lastNameInput.value, 15, 'Last name is required');
            if (result.valid && lastNameInput.value) {
                const patternResult = validateText(lastNameInput.value, "^[A-Za-z\s'-]+$", 15, "Only letters, spaces, apostrophes and dashes are allowed");
                lastNameInput.value = patternResult.valid ? lastNameInput.value : lastNameInput.value.replace(/[^A-Za-z\s'-]/g, '').substring(0, 15);
                lastNameMessage.textContent = patternResult.message;
                lastNameMessage.className = 'validation-message' + (formSubmitted && !patternResult.valid ? ' error' : '');
                lastNameInput.setCustomValidity(patternResult.valid ? '' : patternResult.message);
            } else {
                lastNameMessage.textContent = result.message;
                lastNameMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
                lastNameInput.setCustomValidity(result.message);
            }
            lastNameCounter.textContent = `Characters: ${lastNameInput.value.length}/15${lastNameInput.value.length === 15 ? ' (Maximum reached)' : ''}`;
            lastNameCounter.style.color = lastNameInput.value.length === 15 ? 'red' : '#555';
        }

        function updateEmailFeedback() {
            const result = validateEmail(emailInput.value);
            emailMessage.textContent = result.message;
            emailMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            emailInput.setCustomValidity(result.valid ? '' : result.message);
            emailCounter.textContent = `Characters: ${emailInput.value.length}/255${emailInput.value.length === 255 ? ' (Maximum reached)' : ''}`;
            emailCounter.style.color = emailInput.value.length === 255 ? 'red' : '#555';
        }

        function updatePhoneFeedback() {
            const result = validateText(phoneInput.value, "^[0-9]{10}$", 10, "Phone number must be exactly 10 digits", true);
            phoneInput.value = result.valid ? phoneInput.value : phoneInput.value.replace(/[^0-9]/g, '').substring(0, 10);
            phoneMessage.textContent = result.message;
            phoneMessage.className = 'validation-message' + (formSubmitted && !result.valid && phoneInput.value ? ' error' : '');
            phoneInput.setCustomValidity(result.valid ? '' : result.message);
            phoneCounter.textContent = `Characters: ${phoneInput.value.length}/10${phoneInput.value.length === 10 ? ' (Maximum reached)' : ''}`;
            phoneCounter.style.color = phoneInput.value.length === 10 ? 'red' : '#555';
        }

        function updatePostcodeFeedback() {
            const result = validateText(postcodeInput.value, "^[0-9]{4,}$", 10, "Postcode must be at least 4 digits", true);
            postcodeInput.value = result.valid ? postcodeInput.value : postcodeInput.value.replace(/[^0-9]/g, '').substring(0, 10);
            postcodeMessage.textContent = result.message;
            postcodeMessage.className = 'validation-message' + (formSubmitted && !result.valid && postcodeInput.value ? ' error' : '');
            postcodeInput.setCustomValidity(result.valid ? '' : result.message);
            postcodeCounter.textContent = `Characters: ${postcodeInput.value.length}/10${postcodeInput.value.length === 10 ? ' (Maximum reached)' : ''}`;
            postcodeCounter.style.color = postcodeInput.value.length === 10 ? 'red' : '#555';
        }

        function updateOccupationFeedback() {
            const result = validateText(occupationInput.value, "^[A-Za-z\\s'-]+$", 100, "Only letters, spaces, apostrophes and dashes are allowed", true);
            occupationInput.value = result.valid ? occupationInput.value : occupationInput.value.replace(/[^A-Za-z\s'-]/g, '');
            occupationMessage.textContent = result.message;
            occupationMessage.className = 'validation-message' + (formSubmitted && !result.valid && occupationInput.value ? ' error' : '');
            occupationInput.setCustomValidity(result.valid ? '' : result.message);
            occupationCounter.textContent = `Characters: ${occupationInput.value.length}/100${occupationInput.value.length === 100 ? ' (Maximum reached)' : ''}`;
            occupationCounter.style.color = occupationInput.value.length === 100 ? 'red' : '#555';
        }

        function updateDescriptionFeedback() {
            const words = descriptionInput.value.trim().split(/\s+/);
            const wordCount = descriptionInput.value.trim() ? words.length : 0;
            descriptionCounter.textContent = `Words: ${wordCount}/50${wordCount >= 50 ? ' (Maximum reached)' : ''}`;
            descriptionCounter.style.color = wordCount >= 50 ? 'red' : '#555';
            if (wordCount >= 50) {
                const trimmed = words.slice(0, 50).join(' ');
                descriptionInput.value = trimmed;
            }
        }

        function updateStatusFeedback() {
            const result = { valid: true, message: '' }; // Status is optional
            statusMessage.textContent = result.message;
            statusMessage.className = 'validation-message';
            statusInput.setCustomValidity('');
        }

        // Initialize validation on page load
        updateFirstNameFeedback();
        updateLastNameFeedback();
        updateEmailFeedback();
        updatePhoneFeedback();
        updatePostcodeFeedback();
        updateOccupationFeedback();
        updateDescriptionFeedback();
        updateStatusFeedback();

        // Attach event listeners for real-time updates
        firstNameInput.addEventListener('input', updateFirstNameFeedback);
        lastNameInput.addEventListener('input', updateLastNameFeedback);
        emailInput.addEventListener('input', updateEmailFeedback);
        phoneInput.addEventListener('input', updatePhoneFeedback);
        postcodeInput.addEventListener('input', updatePostcodeFeedback);
        occupationInput.addEventListener('input', updateOccupationFeedback);
        descriptionInput.addEventListener('input', updateDescriptionFeedback);
        statusInput.addEventListener('change', updateStatusFeedback);

        // Prevent form submission if validation fails
        const form = document.querySelector('form');
        form.addEventListener('submit', function(e) {
            formSubmitted = true;
            updateFirstNameFeedback();
            updateLastNameFeedback();
            updateEmailFeedback();
            updatePhoneFeedback();
            updatePostcodeFeedback();
            updateOccupationFeedback();
            updateStatusFeedback();
            if (!validateRequiredText(firstNameInput.value, 100, 'First name is required').valid ||
                !validateRequiredText(lastNameInput.value, 100, 'Last name is required').valid ||
                !validateEmail(emailInput.value).valid ||
                (!validateText(phoneInput.value, "^[0-9]{10}$", 10, "Phone number must be exactly 10 digits", true).valid && phoneInput.value) ||
                (!validateText(postcodeInput.value, "^[0-9]{4,}$", 10, "Postcode must be at least 4 digits", true).valid && postcodeInput.value) ||
                (!validateText(occupationInput.value, "^[A-Za-z\\s'-]+$", 100, "Only letters, spaces, apostrophes and dashes are allowed", true).valid && occupationInput.value)) {
                e.preventDefault();
                firstNameInput.reportValidity();
                lastNameInput.reportValidity();
                emailInput.reportValidity();
                phoneInput.reportValidity();
                postcodeInput.reportValidity();
                occupationInput.reportValidity();
            }
        });
    });
</script>
