<?php
/**
 * @var \App\View\AppView $this
 * @var \Cake\Datasource\ResultSetInterface|\App\Model\Entity\Volunteer[] $volunteers
 * @var string|null $start
 * @var string|null $end
 */
?>
<div class="container-xxl flex-grow-2 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <!-- Date‑range filter form -->
                    <?= $this->Form->create(null, [
                        'url' => ['action' => 'overview'],
                        'type' => 'get',
                        'class' => 'd-flex gap-3'
                    ]) ?>
                    <?= $this->Form->control('start_date', [
                        'type' => 'date',
                        'label' => false,
                        'value' => $start,
                        'class' => 'form-control'
                    ]) ?>
                    <?= $this->Form->control('end_date', [
                        'type' => 'date',
                        'label' => false,
                        'value' => $end,
                        'class' => 'form-control'
                    ]) ?>
                    <?= $this->Form->button(__('Filter'), ['class' => 'btn btn-outline-primary']) ?>
                    <?= $this->Form->end() ?>

                    <div>
                        <?= $this->Html->link(
                            __('Back to Volunteers'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            'Preview CSV',
                            ['action' => 'preview', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-info me-2']
                        ) ?>
                        <?= $this->Html->link(
                            __('New Volunteer'),
                            ['action' => 'add'],
                            ['class' => 'btn btn-primary']
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('first_name') ?></th>
                                <th><?= $this->Paginator->sort('last_name') ?></th>
                                <th><?= $this->Paginator->sort('email') ?></th>
                                <th><?= $this->Paginator->sort('phone') ?></th>
                                <th><?= $this->Paginator->sort('postcode') ?></th>
                                <th><?= $this->Paginator->sort('occupation') ?></th>
                                <th><?= $this->Paginator->sort('registration_date', 'Registered') ?></th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($volunteers as $volunteer): ?>
                                <tr>
                                    <td><?= h($volunteer->first_name) ?></td>
                                    <td><?= h($volunteer->last_name) ?></td>
                                    <td><?= h($volunteer->email) ?></td>
                                    <td><?= h($volunteer->phone) ?></td>
                                    <td><?= h($volunteer->postcode) ?></td>
                                    <td><?= h($volunteer->occupation) ?></td>
                                    <td><?= $volunteer->registration_date?->format('Y‑m‑d') ?></td>
                                    <td class="actions">
                                        <?= $this->Html->link('View', ['action'=>'view', $volunteer->id], ['class'=>'btn btn-sm btn-outline-secondary']) ?>
                                        <?= $this->Html->link('Edit', ['action'=>'edit', $volunteer->id], ['class'=>'btn btn-sm btn-outline-primary']) ?>
                                        <?= $this->Form->postLink('Delete', ['action'=>'delete', $volunteer->id], [
                                            'confirm' => __('Are you sure you want to delete # {0}?', $volunteer->id),
                                            'class'=>'btn btn-sm btn-outline-danger'
                                        ]) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <nav aria-label="Page navigation" class="mt-4">
                        <ul class="pagination justify-content-center">
                            <?= $this->Paginator->first('', ['class'=>'page-item','escape'=>false,'template'=>'<li class="page-item"><a class="page-link">{{text}}</a></li>']) ?>
                            <?= $this->Paginator->prev('', ['class'=>'page-item','escape'=>false]) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next('', ['class'=>'page-item','escape'=>false]) ?>
                            <?= $this->Paginator->last('', ['class'=>'page-item','escape'=>false]) ?>
                        </ul>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter() ?>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
