<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Volunteer> $volunteers
 * @var string|null $start
 * @var string|null $end
 */
?>
<div class="container-xxl flex-grow-2 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">CSV Preview (<?= h($start) ?> → <?= h($end) ?>)</h5>
                    <div>
                        <?= $this->Html->link(
                            __('Back to Overview'),
                            ['action' => 'overview', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-secondary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            __('Download CSV'),
                            ['action' => 'export', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-success']
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('first_name') ?></th>
                                <th><?= $this->Paginator->sort('last_name') ?></th>
                                <th><?= $this->Paginator->sort('email') ?></th>
                                <th><?= $this->Paginator->sort('phone') ?></th>
                                <th><?= $this->Paginator->sort('postcode') ?></th>
                                <th><?= $this->Paginator->sort('occupation') ?></th>
                                <th><?= $this->Paginator->sort('status', 'Status') ?></th>
                                <th><?= $this->Paginator->sort('registration_date', 'Registered') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($volunteers as $v): ?>
                                <tr>
                                    <td><?= h($v->first_name) ?></td>
                                    <td><?= h($v->last_name) ?></td>
                                    <td><?= h($v->email) ?></td>
                                    <td><?= h($v->phone) ?></td>
                                    <td><?= h($v->postcode) ?></td>
                                    <td><?= h($v->occupation) ?></td>
                                    <td><?= h($v->status) ?></td>
                                    <td><?= $v->registration_date?->format('Y-m-d') ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <nav aria-label="Page navigation" class="mt-4">
                        <ul class="pagination justify-content-center">
                            <?= $this->Paginator->first('', ['class'=>'page-item','escape'=>false]) ?>
                            <?= $this->Paginator->prev('', ['class'=>'page-item','escape'=>false]) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next('', ['class'=>'page-item','escape'=>false]) ?>
                            <?= $this->Paginator->last('', ['class'=>'page-item','escape'=>false]) ?>
                        </ul>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter() ?>
                        </div>
                    </nav>
                </div>

            </div>
        </div>
    </div>
</div>
