<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Volunteer> $volunteers
 * @var array $insertedVolunteers
 * @var array $failedVolunteers
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Render flash messages -->
    <?= $this->Flash->render() ?>

    <!-- Upload Modal -->

    <!-- PDF Report Section -->
    <?php if ($this->request->getSession()->check('pdf_file')): ?>
        <div class="card mb-4" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow); background: #fff;">
            <div class="card-body text-center">
                <h4 class="card-title" style="color: var(--orange-dark); font-weight: 700; text-transform: uppercase; letter-spacing: 1px;">PDF Report Generated</h4>
                <p class="card-text" style="color: var(--grey);">Your volunteer upload report has been generated successfully and is downloading.</p>
                <div class="download-container">
                    <?= $this->Html->link(
                        '<i class="bx bx-download me-1"></i> Download PDF Again',
                        '/' . $this->request->getSession()->read('pdf_file'),
                        ['class' => 'btn btn-primary', 'escape' => false, 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; margin-right: 10px; transition: var(--transition);']
                    ) ?>
<!--                    <button class="btn btn-secondary" onclick="window.location.href='--><?php //= $this->Url->build(['controller' => 'Volunteers', 'action' => 'index']) ?>//';">
//                        Back to Volunteers
//                    </button>
                </div>
            </div>
        </div>
        <?php $this->request->getSession()->delete('pdf_file'); ?>
    <?php elseif (!empty($insertedVolunteers) || !empty($failedVolunteers)): ?>
        <div class="card mb-4" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow); background: #fff;">
            <div class="card-header d-flex justify-content-between align-items-center" style="border-bottom: 1px solid var(--grey-light);">
                <h4 style="color: var(--orange-dark); font-weight: 700; text-transform: uppercase; letter-spacing: 1px;">Preview Certificate Data</h4>
                <?= $this->Html->link('Go to Certificate', ['controller' => 'Certificate', 'action' => 'index'], ['class' => 'btn btn-primary']) ?>   </div>
            <div class="card-body">
                <h5 style="color: var(--orange-dark); font-weight: 700;">Successfully Uploaded Volunteers (<?= count($insertedVolunteers) ?>)</h5>
                <?php if (!empty($insertedVolunteers)): ?>
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                            <thead style="background: var(--grey-lighter);">
                            <tr>
                                <th style="color: var(--orange-dark); font-weight: 700;">Certificate ID</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Volunteer Name</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Badges</th>
<!--                                <th style="color: var(--orange-dark); font-weight: 700;">Certified</th>-->
                                <th style="color: var(--orange-dark); font-weight: 700;">Program Name1</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Program Name2</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Program Name3</th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($insertedVolunteers as $v): ?>
                                <tr>
                                    <td style="color: var(--grey-dark);"><?= h($v['docuniqueid']) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($v['volunteer']) ?></td>
                                    <td><span class="badge bg-label-info" style="background: var(--blue); color: #fff; border-radius: var(--radius-sm); font-weight: 600;"><?= h($v['badges']) ?></span></td>
<!--                                    <td style="color: var(--grey-dark);">--><?php //= h($v['certified']) ?><!--</td>-->
                                    <td style="color: var(--grey-dark);"><?= h($v['program_name1']) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($v['program_name2']) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($v['program_name3']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted" style="color: var(--grey);">No successful uploads.</p>
                <?php endif; ?>

                <h5 class="mt-4" style="color: var(--orange-dark); font-weight: 700;">Failed Volunteers (<?= count($failedVolunteers) ?>)</h5>
                <?php if (!empty($failedVolunteers)): ?>
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                            <thead style="background: var(--grey-lighter);">
                            <tr>
                                <th style="color: var(--orange-dark); font-weight: 700;">Email</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Badges</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Certified</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Program ID1</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Program ID2</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Program ID3</th>
                                <th style="color: var(--orange-dark); font-weight: 700;">Reason</th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($failedVolunteers as $f):
                                $data = (object)$f['data'];
                                ?>
                                <tr>
                                    <td style="color: var(--grey-dark);"><?= h($data->email ?? '') ?></td>
                                    <td><span class="badge bg-label-info" style="background: var(--blue); color: #fff; border-radius: var(--radius-sm); font-weight: 600;"><?= h($data->badges ?? '') ?></span></td>
                                    <td style="color: var(--grey-dark);"><?= h($data->certified ?? '') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($data->program_id1 ?? '') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($data->program_id2 ?? '') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($data->program_id3 ?? '') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($f['reason']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted" style="color: var(--grey);">No failed uploads.</p>
                <?php endif; ?>

                <!-- Download PDF Button -->
                <div class="mt-4 text-center">
                    <?= $this->Form->create(null, ['url' => ['action' => 'downloadPdf'], 'type' => 'post']) ?>
                    <?= $this->Form->hidden('insertedVolunteers', ['value' => base64_encode(serialize($insertedVolunteers))]) ?>
                    <?= $this->Form->hidden('failedVolunteers', ['value' => base64_encode(serialize($failedVolunteers))]) ?>
                    <?= $this->Form->button('Download PDF Report', ['class' => 'btn btn-primary', 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; transition: var(--transition);']) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Volunteer List Section -->
        <div class="card mb-4" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow); background: #fff; position: relative; overflow: hidden;">
            <div class="card-header d-flex justify-content-between align-items-center" style="border-bottom: 1px solid var(--grey-light); padding: calc(var(--spacing) * 1.5);">
                <h3 style="color: var(--orange-dark); font-weight: 700; font-family: 'Poppins', sans-serif;">Volunteers</h3>
                <div>
                    <?= $this->Html->link(
                        'Export CSV',
                        ['action' => 'overview'],
                        ['class' => 'btn btn-outline-primary me-2', 'style' => 'border: 2px solid var(--blue); color: var(--blue); border-radius: var(--radius-sm); font-weight: 600; transition: var(--transition);']
                    ) ?>
                    <?= $this->Html->link(
                        'Upload File',
                        '#',
                        [
                            'class' => 'btn btn-primary me-2',
                            'data-bs-toggle' => 'modal',
                            'data-bs-target' => '#uploadModal',
                            'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);'
                        ]
                    ) ?>
                    <?= $this->Html->link('Add Volunteer', ['action' => 'add'], ['class' => 'btn btn-primary', 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);']) ?>
                </div>
            </div>
            <div class="card-body" style="padding: calc(var(--spacing) * 1.5);">
                <div class="d-flex justify-content-end mb-4">
                    <?= $this->Form->create(null, ['type' => 'get']) ?>
                    <div class="input-group mb-3" style="max-width: 400px;">
                        <?= $this->Form->control('search', [
                            'label' => false,
                            'value' => $this->request->getQuery('search'),
                            'class' => 'form-control',
                            'placeholder' => 'Search name, email or status',
                            'type' => 'text',
                            'style' => 'width: 100%; border: 1px solid var(--grey-light); border-radius: var(--radius-sm); color: var(--grey-dark);'
                        ]) ?>
                        <?= $this->Form->button('Search', [
                            'class' => 'btn btn-primary',
                            'style' => 'margin-left: 8px; background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; transition: var(--transition);'
                        ]) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
                <div class="table-responsive text-nowrap">
                    <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                        <thead style="background: var(--grey-lighter);">
                        <tr>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('name') ?></th>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('email') ?></th>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('phone') ?></th>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('postcode') ?></th>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('occupation') ?></th>
                            <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('volunteer_status_id', 'Status') ?></th>
                        </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                        <?php foreach ($volunteers as $volunteer): ?>
                            <tr data-edit-url="<?= $this->Url->build(['controller' => 'Volunteers', 'action' => 'edit', $volunteer->id]) ?>" class="clickable-row" style="transition: var(--transition);">
                                <td style="color: var(--grey-dark);"><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></td>
                                <td>
                                    <a href="mailto:<?= h($volunteer->email) ?>" style="text-decoration: underline; color: var(--orange); transition: var(--transition);">
                                        <?= h($volunteer->email) ?>
                                    </a>
                                </td>
                                <td>
                                    <a href="tel:<?= h($volunteer->phone) ?>" style="text-decoration: underline; color: var(--orange); transition: var(--transition);">
                                        <?= h($volunteer->phone) ?>
                                    </a>
                                </td>
                                <td style="color: var(--grey-dark);"><?= h($volunteer->postcode) ?></td>
                                <td style="color: var(--grey-dark);"><?= h($volunteer->occupation) ?></td>
                                <td>
                                    <?php if ($volunteer->hasValue('volunteer_status')): ?>
                                        <span class="badge bg-label-primary" style="background: var(--blue); color: #fff; border-radius: var(--radius-sm); font-weight: 600;">
                                            <?= $volunteer->volunteer_status->name ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?= $this->Paginator->first('<i class="fas fa-chevron-double-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            <?= $this->Paginator->prev('<i class="fas fa-chevron-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            <?php
                            $this->Paginator->setTemplates([
                                'number' => '<li class="page-item"><a class="page-link" href="{{url}}" style="color: var(--blue);">{{text}}</a></li>',
                                'current' => '<li class="page-item active"><a class="page-link" href="#" style="background: var(--orange); border-color: var(--orange); color: #fff;">{{text}}</a></li>',
                            ]);
                            echo $this->Paginator->numbers();
                            ?>
                            <?= $this->Paginator->next('<i class="fas fa-chevron-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            <?= $this->Paginator->last('<i class="fas fa-chevron-double-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                        </ul>
                    </nav>
                    <div class="text-center text-muted mt-2" style="color: var(--grey);">
                        <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
    }

    .container-xxl {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card {
        background: #fff;
        border-radius: var(--radius);
        box-shadow: 0 12px 40px var(--shadow);
    }

    .card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 8px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
    }

    .card-header {
        background: #fff;
        border-bottom: 1px solid var(--grey-light);
        padding: calc(var(--spacing) * 1.5);
    }

    .btn-primary:hover, .btn-outline-primary:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .btn-outline-primary:hover {
        background: var(--blue);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--orange-dark);
    }

    .btn-secondary {
        background: var(--grey-light);
        color: var(--grey-dark);
        border: none;
        border-radius: var(--radius-sm);
        font-weight: 600;
        transition: var(--transition);
    }

    .btn-secondary:hover {
        background: #e0e0e0;
        transform: translateY(-2px);
    }

    .table-striped tbody tr:hover {
        background: var(--grey-light);
        transform: scale(1.02);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .badge.bg-label-info {
        background: var(--blue);
        color: #fff;
        font-weight: 600;
    }

    .pagination .page-link:hover {
        background: var(--orange-light);
        color: #fff;
    }

    .download-container {
        text-align: center;
        margin: 20px;
    }

    @media (max-width: 768px) {
        .container-xxl {
            padding: 15px;
        }

        .card-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .input-group.mb-3 {
            flex-direction: column;
            width: 100%;
        }

        .input-group.mb-3 input,
        .input-group.mb-3 button {
            width: 100% !important;
            margin-top: 8px;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .pagination .page-item {
            font-size: 14px;
        }

        .modal-dialog {
            max-width: 100%;
            margin: 0 10px;
        }

        .card-body .d-flex {
            flex-direction: column;
            align-items: stretch;
        }
    }
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        if (uploadForm) {
            uploadForm.addEventListener('submit', function () {
                setTimeout(() => {
                    uploadModal.hide();
                }, 500);
            });
        }

        const tbody = document.querySelector('tbody');
        if (tbody) {
            tbody.addEventListener('click', function(event) {
                const row = event.target.closest('.clickable-row');
                if (row) {
                    const editUrl = row.getAttribute('data-edit-url');
                    if (editUrl) {
                        window.location.href = editUrl;
                    }
                }
            });
        }

        // Animate cards and tables
        gsap.from('.card, .table', {
            opacity: 0,
            y: 50,
            duration: 1,
            ease: 'power3.out',
            stagger: 0.2
        });
    });
</script>
