<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 */
?>
<div class="container">
    <div class="header-container">
        <h3 class="program-header"><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></h3>
        <!-- Optional: Add a download or export button if needed -->
        <?= $this->Html->link(
            'Export <i class="bx bx-export me-1"></i>',
            ['action' => 'exportVolunteer', $volunteer->id],
            ['class' => 'download-btn', 'escape' => false]
        ) ?>
    </div>

    <table class="info-table">
        <tr>
            <th>First Name</th>
            <td><?= h($volunteer->first_name) ?></td>
        </tr>
        <tr>
            <th>Last Name</th>
            <td><?= h($volunteer->last_name) ?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td>
                <a href="mailto:<?= h($volunteer->email) ?>" style="text-decoration: underline;">
                    <?= h($volunteer->email) ?>
                </a>
            </td>
        </tr>
        <tr>
            <th>Phone</th>
            <td>
                <a href="tel:<?= h($volunteer->phone) ?>" style="text-decoration: underline;">
                    <?= h($volunteer->phone) ?>
                </a>
            </td>
        </tr>
        <tr>
            <th>Postcode</th>
            <td><?= h($volunteer->postcode) ?></td>
        </tr>
        <tr>
            <th>Occupation</th>
            <td><?= h($volunteer->occupation) ?></td>
        </tr>
        <tr>
            <th>Volunteer Status</th>
            <td>
                <?= $volunteer->hasValue('volunteer_status') ?
                    $this->Html->link($volunteer->volunteer_status->name,
                        ['controller' => 'VolunteerStatuses', 'action' => 'view', $volunteer->volunteer_status->id]) : '' ?>
            </td>
        </tr>
        <tr>
            <th>ID</th>
            <td><?= $this->Number->format($volunteer->id) ?></td>
        </tr>
    </table>

    <!-- Description Section -->
    <div class="related-section">
        <h4>Description</h4>
        <div class="description-content">
            <?= $this->Text->autoParagraph(h($volunteer->description)) ?>
        </div>
    </div>

    <!-- Related Programs -->
    <div class="related-section">
        <h4>Related Programs</h4>
        <?php if (!empty($volunteer->programs)) : ?>
            <div class="responsive-table">
                <table class="data-table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Program Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($volunteer->programs as $program) : ?>
                        <tr>
                            <td><?= h($program->id) ?></td>
                            <td><?= h($program->name) ?></td>
                            <td><?= h($program->date) ?></td>
                            <td><?= h($program->time) ?></td>
                            <td><?= h($program->program_status_id) ?></td>
                            <td class="actions">
                                <?= $this->Html->link('View', ['controller' => 'Programs', 'action' => 'view', $program->id]) ?>
                                <?= $this->Html->link('Edit', ['controller' => 'Programs', 'action' => 'edit', $program->id]) ?>
                                <?= $this->Form->postLink('Delete', ['controller' => 'Programs', 'action' => 'delete', $program->id], ['confirm' => __('Are you sure you want to delete # {0}?', $program->id)]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    * {
        box-sizing: border-box;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .program-header {
        color: #333;
        margin: 0;
    }

    .download-btn {
        background-color: #e87532;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 20px;
        cursor: pointer;
        font-size: 14px;
        transition: background-color 0.3s;
    }

    .download-btn:hover {
        background-color: #9f3e02;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 30px;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .info-table th,
    .info-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }

    .info-table th {
        background: #f5f5f5;
        width: 30%;
    }

    .related-section {
        margin: 30px 0;
    }

    .related-section h4 {
        color: #2c3e50;
        margin-bottom: 15px;
        border-bottom: 2px solid #e87532;
        padding-bottom: 5px;
    }

    .description-content {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 5px;
        line-height: 1.6;
    }

    .responsive-table {
        overflow-x: auto;
        margin-bottom: 20px;
    }

    .data-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .data-table th,
    .data-table td {
        padding: 12px;
        border-bottom: 1px solid #eee;
    }

    .data-table th {
        background: #e87532;
        color: white;
        white-space: nowrap;
    }

    .actions a {
        text-decoration: none;
        padding: 5px 10px;
        margin: 0 2px;
        border-radius: 3px;
        color: #fff;
        display: inline-block;
    }

    .actions a:first-child {
        background: #2ecc71;
    }

    .actions a:nth-child(2) {
        background: #e67e22;
    }

    .actions a:last-child {
        background: #e74c3c;
    }

    @media (max-width: 768px) {
        .header-container {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .download-btn {
            width: 100%;
        }

        .info-table th,
        .info-table td {
            display: block;
            width: 100%;
        }

        .info-table th {
            background: #f0f0f0;
        }

        .data-table {
            display: block;
            overflow-x: auto;
            white-space: nowrap;
        }

        .actions {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
        }
    }
</style>
