<div class="container-xxl flex-grow-1 container-p-y">
    <?= $this->Flash->render() ?>

    <div class="card">
        <div class="card-header">
            <!-- Display the page title -->
            <h2>Donation Details</h2>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <tr>
                    <th>ID</th>
                    <td><?= $donation->id ?></td>
                </tr>
                <tr>
                    <th>Amount</th>
                    <td>$<?= number_format($donation->amount, 2) ?></td>
                </tr>
                <tr>
                    <th>Donor Email</th>
                    <td><?= h($donation->donor_email) ?></td>
                </tr>
                <tr>
                    <th>Donor Name</th>
                    <td><?= h($donation->donor_name ?? 'N/A') ?></td>
                </tr>
                <tr>
                    <th>Transaction ID</th>
                    <td><?= h($donation->stripe_transaction_id) ?></td>
                </tr>
                <tr>
                    <th>Status</th>
                    <td><?= h($donation->status) ?></td>
                </tr>
                <tr>
                    <th>Created</th>
                    <td><?= $donation->created->format('Y-m-d H:i:s') ?></td>
                </tr>
                <tr>
                    <th>Modified</th>
                    <td><?= $donation->modified->format('Y-m-d H:i:s') ?></td>
                </tr>
                <tr>
                    <th>Campaign</th>
                    <td><?= $donation->campaign ? h($donation->campaign->title) : 'N/A' ?></td>
                </tr>
            </table>
            <p class="mt-4">
                <?= $this->Html->link('Back to Donations List', ['action' => 'index'], ['class' => 'btn btn-primary']) ?>
            </p>
        </div>
    </div>
</div>