<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\ContentBlocks\Model\Entity\ContentBlock> $contentBlocksGrouped
 */

$this->assign('title', 'Content Blocks');

$this->Html->css('ContentBlocks.content-blocks', ['block' => true]);

$slugify = function($text) {
    return preg_replace('/[^A-Za-z0-9-]+/', '-', $text);
}
?>

<div class="page-container">
    <div class="row gx-5 justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow">
                <div class="card-body">
                    <h3 class="content-section-title"><?= __('Content Blocks') ?></h3>

                    <div class="quick-links">
                        Quick links
                        <?php foreach(array_keys($contentBlocksGrouped) as $parent) { ?>
                            :: <a href="#<?= $slugify($parent) ?>"><?= $parent ?></a>
                        <?php } ?>
                    </div>

                    <?php foreach($contentBlocksGrouped as $parent => $contentBlocks) { ?>
                        <h4 class="content-blocks--list-subheading">
                            <a href="#<?= $slugify($parent)?>" id="<?= $slugify($parent)?>">
                                <?= $parent ?>
                            </a>
                        </h4>

                        <ul class="content-blocks--list-group">
                            <?php foreach($contentBlocks as $contentBlock) { ?>
                                <li class="content-blocks--list-group-item">
                                    <div class="content-blocks--text">
                                        <div class="content-blocks--display-name">
                                            <?= $contentBlock['label'] ?>
                                        </div>
                                        <div class="content-blocks--description">
                                            <?= $contentBlock['description'] ?>
                                        </div>
                                    </div>
                                    <div class="content-blocks--actions">
                                        <?= $this->Html->link(__('Edit'),
                                            ['action' => 'edit', $contentBlock->id],
                                            ['class' => 'btn btn-primary btn-sm']
                                        ) ?>

                                        <?php if (!empty($contentBlock->previous_value)) : ?>
                                            <?= " :: " . $this->Form->postLink(__('Restore'),
                                                ['action' => 'restore', $contentBlock->id],
                                                ['confirm' => __("Are you sure you want to restore the previous version for this item?\n{0}/{1}\nNote: You cannot cancel this action!", $contentBlock->parent, $contentBlock->slug),
                                                    'class' => 'btn btn-warning btn-sm'])
                                            ?>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    * { box-sizing: border-box; margin: 0; padding: 0; }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
        overflow-x: hidden;
    }

    body::before {
        content: "";
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
        radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
        z-index: -1;
    }

    .page-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card {
        background: #fff;
        border-radius: var(--radius);
        box-shadow: 0 12px 40px var(--shadow);
        padding: calc(var(--spacing) * 2);
        margin-bottom: calc(var(--spacing) * 2.5);
        position: relative;
    }

    .card-body {
        padding: 0;
    }

    .content-section-title {
        font-family: "Poppins", sans-serif;
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--grey-dark);
        text-align: center;
        margin-bottom: calc(var(--spacing) * 2);
        position: relative;
    }

    .content-section-title::after {
        content: "";
        position: absolute;
        bottom: -12px;
        left: 50%;
        transform: translateX(-50%);
        width: 120px;
        height: 6px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
        border-radius: 6px;
    }

    .quick-links {
        text-align: center;
        font-size: 1.1rem;
        color: var(--grey);
        margin-bottom: calc(var(--spacing) * 2);
    }

    .quick-links a {
        color: var(--orange);
        text-decoration: none;
        font-weight: 600;
        transition: var(--transition);
    }

    .quick-links a:hover {
        color: var(--orange-dark);
        text-decoration: underline;
    }

    .content-blocks--list-subheading {
        font-family: "Poppins", sans-serif;
        font-size: 1.7rem;
        color: var(--orange);
        font-weight: 700;
        position: relative;
        padding-bottom: 15px;
        margin-bottom: calc(var(--spacing) * 1.5);
    }

    .content-blocks--list-subheading::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        width: 70px;
        height: 5px;
        background: var(--orange-light);
        border-radius: 5px;
    }

    .content-blocks--list-subheading a {
        color: inherit;
        text-decoration: none;
    }

    .content-blocks--list-group {
        list-style: none;
        padding: 0;
        margin-bottom: calc(var(--spacing) * 2);
    }

    .content-blocks--list-group-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #fff;
        border-radius: var(--radius-sm);
        padding: calc(var(--spacing) * 1);
        margin-bottom: calc(var(--spacing) * 0.5);
        border: 1px solid var(--grey-light);
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .content-blocks--list-group-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        border-color: var(--orange-light);
    }

    .content-blocks--text {
        flex: 1;
    }

    .content-blocks--display-name {
        font-size: 1.2rem;
        font-weight: 600;
        color: var(--grey-dark);
    }

    .content-blocks--description {
        font-size: 1rem;
        color: var(--grey);
        margin-top: 5px;
    }

    .content-blocks--actions {
        display: flex;
        gap: 10px;
    }

    .btn-primary {
        padding: 8px 20px;
        background: var(--orange);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        font-size: 0.9rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(232, 117, 51, 0.3);
    }

    .btn-primary:hover {
        background: var(--orange-dark);
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(232, 117, 51, 0.4);
    }

    .btn-warning {
        padding: 8px 20px;
        background: var(--blue);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        font-size: 0.9rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(62, 136, 242, 0.3);
    }

    .btn-warning:hover {
        background: var(--blue-light);
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(62, 136, 242, 0.4);
    }

    @media (max-width: 768px) {
        .page-container {
            padding: 15px;
        }

        .card {
            padding: 20px;
        }

        .content-section-title {
            font-size: 1.8rem;
        }

        .quick-links {
            font-size: 1rem;
        }

        .content-blocks--list-subheading {
            font-size: 1.4rem;
        }

        .content-blocks--list-group-item {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
            padding: calc(var(--spacing) * 0.75);
        }

        .content-blocks--display-name {
            font-size: 1.1rem;
        }

        .content-blocks--description {
            font-size: 0.9rem;
        }

        .content-blocks--actions {
            flex-direction: row;
            gap: 8px;
            width: 100%;
            justify-content: flex-end;
        }

        .btn-primary, .btn-warning {
            font-size: 0.8rem;
            padding: 6px 16px;
        }
    }
</style>
