"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Avatar: () => Avatar,
  AvatarPropsDefaults: () => AvatarPropsDefaults,
  AvatarPropsSchema: () => AvatarPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var AvatarPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    textAlign: import_zod.z.enum(["left", "center", "right"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    size: import_zod.z.number().gt(0).optional().nullable(),
    shape: import_zod.z.enum(["circle", "square", "rounded"]).optional().nullable(),
    imageUrl: import_zod.z.string().optional().nullable(),
    alt: import_zod.z.string().optional().nullable()
  }).optional().nullable()
});
function getBorderRadius(shape, size) {
  switch (shape) {
    case "rounded":
      return size * 0.125;
    case "circle":
      return size;
    case "square":
    default:
      return void 0;
  }
}
var AvatarPropsDefaults = {
  size: 64,
  imageUrl: "",
  alt: "",
  shape: "square"
};
function Avatar({ style, props }) {
  var _a, _b, _c, _d, _e;
  const size = (_a = props == null ? void 0 : props.size) != null ? _a : AvatarPropsDefaults.size;
  const imageUrl = (_b = props == null ? void 0 : props.imageUrl) != null ? _b : AvatarPropsDefaults.imageUrl;
  const alt = (_c = props == null ? void 0 : props.alt) != null ? _c : AvatarPropsDefaults.alt;
  const shape = (_d = props == null ? void 0 : props.shape) != null ? _d : AvatarPropsDefaults.shape;
  const sectionStyle = {
    textAlign: (_e = style == null ? void 0 : style.textAlign) != null ? _e : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  return /* @__PURE__ */ import_react.default.createElement("div", { style: sectionStyle }, /* @__PURE__ */ import_react.default.createElement(
    "img",
    {
      alt,
      src: imageUrl,
      height: size,
      width: size,
      style: {
        outline: "none",
        border: "none",
        textDecoration: "none",
        objectFit: "cover",
        height: size,
        width: size,
        maxWidth: "100%",
        display: "inline-block",
        verticalAlign: "middle",
        textAlign: "center",
        borderRadius: getBorderRadius(shape, size)
      }
    }
  ));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Avatar,
  AvatarPropsDefaults,
  AvatarPropsSchema
});
