"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Button: () => Button,
  ButtonPropsDefaults: () => ButtonPropsDefaults,
  ButtonPropsSchema: () => ButtonPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var FONT_FAMILY_SCHEMA = import_zod.z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
function getFontFamily(fontFamily) {
  switch (fontFamily) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
  return void 0;
}
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ButtonPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    backgroundColor: COLOR_SCHEMA,
    fontSize: import_zod.z.number().min(0).optional().nullable(),
    fontFamily: FONT_FAMILY_SCHEMA,
    fontWeight: import_zod.z.enum(["bold", "normal"]).optional().nullable(),
    textAlign: import_zod.z.enum(["left", "center", "right"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    buttonBackgroundColor: COLOR_SCHEMA,
    buttonStyle: import_zod.z.enum(["rectangle", "pill", "rounded"]).optional().nullable(),
    buttonTextColor: COLOR_SCHEMA,
    fullWidth: import_zod.z.boolean().optional().nullable(),
    size: import_zod.z.enum(["x-small", "small", "large", "medium"]).optional().nullable(),
    text: import_zod.z.string().optional().nullable(),
    url: import_zod.z.string().optional().nullable()
  }).optional().nullable()
});
function getRoundedCorners(props) {
  var _a;
  const buttonStyle = (_a = props == null ? void 0 : props.buttonStyle) != null ? _a : ButtonPropsDefaults.buttonStyle;
  switch (buttonStyle) {
    case "rectangle":
      return void 0;
    case "pill":
      return 64;
    case "rounded":
    default:
      return 4;
  }
}
function getButtonSizePadding(props) {
  var _a;
  const size = (_a = props == null ? void 0 : props.size) != null ? _a : ButtonPropsDefaults.size;
  switch (size) {
    case "x-small":
      return [4, 8];
    case "small":
      return [8, 12];
    case "large":
      return [16, 32];
    case "medium":
    default:
      return [12, 20];
  }
}
var ButtonPropsDefaults = {
  text: "",
  url: "",
  fullWidth: false,
  size: "medium",
  buttonStyle: "rounded",
  buttonTextColor: "#FFFFFF",
  buttonBackgroundColor: "#999999"
};
function Button({ style, props }) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const text = (_a = props == null ? void 0 : props.text) != null ? _a : ButtonPropsDefaults.text;
  const url = (_b = props == null ? void 0 : props.url) != null ? _b : ButtonPropsDefaults.url;
  const fullWidth = (_c = props == null ? void 0 : props.fullWidth) != null ? _c : ButtonPropsDefaults.fullWidth;
  const buttonTextColor = (_d = props == null ? void 0 : props.buttonTextColor) != null ? _d : ButtonPropsDefaults.buttonTextColor;
  const buttonBackgroundColor = (_e = props == null ? void 0 : props.buttonBackgroundColor) != null ? _e : ButtonPropsDefaults.buttonBackgroundColor;
  const padding = getButtonSizePadding(props);
  const textRaise = padding[1] * 2 * 3 / 4;
  const wrapperStyle = {
    backgroundColor: (_f = style == null ? void 0 : style.backgroundColor) != null ? _f : void 0,
    textAlign: (_g = style == null ? void 0 : style.textAlign) != null ? _g : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  const linkStyle = {
    color: buttonTextColor,
    fontSize: (_h = style == null ? void 0 : style.fontSize) != null ? _h : 16,
    fontFamily: getFontFamily(style == null ? void 0 : style.fontFamily),
    fontWeight: (_i = style == null ? void 0 : style.fontWeight) != null ? _i : "bold",
    backgroundColor: buttonBackgroundColor,
    borderRadius: getRoundedCorners(props),
    display: fullWidth ? "block" : "inline-block",
    padding: `${padding[0]}px ${padding[1]}px`,
    textDecoration: "none"
  };
  return /* @__PURE__ */ import_react.default.createElement("div", { style: wrapperStyle }, /* @__PURE__ */ import_react.default.createElement("a", { href: url, style: linkStyle, target: "_blank" }, /* @__PURE__ */ import_react.default.createElement(
    "span",
    {
      dangerouslySetInnerHTML: {
        __html: `<!--[if mso]><i style="letter-spacing: ${padding[1]}px;mso-font-width:-100%;mso-text-raise:${textRaise}" hidden>&nbsp;</i><![endif]-->`
      }
    }
  ), /* @__PURE__ */ import_react.default.createElement("span", null, text), /* @__PURE__ */ import_react.default.createElement(
    "span",
    {
      dangerouslySetInnerHTML: {
        __html: `<!--[if mso]><i style="letter-spacing: ${padding[1]}px;mso-font-width:-100%" hidden>&nbsp;</i><![endif]-->`
      }
    }
  )));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Button,
  ButtonPropsDefaults,
  ButtonPropsSchema
});
