"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  ColumnsContainer: () => ColumnsContainer,
  ColumnsContainerPropsSchema: () => ColumnsContainerPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var FIXED_WIDTHS_SCHEMA = import_zod.z.tuple([import_zod.z.number().nullish(), import_zod.z.number().nullish(), import_zod.z.number().nullish()]).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ColumnsContainerPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    backgroundColor: COLOR_SCHEMA,
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    fixedWidths: FIXED_WIDTHS_SCHEMA,
    columnsCount: import_zod.z.union([import_zod.z.literal(2), import_zod.z.literal(3)]).optional().nullable(),
    columnsGap: import_zod.z.number().optional().nullable(),
    contentAlignment: import_zod.z.enum(["top", "middle", "bottom"]).optional().nullable()
  }).optional().nullable()
});
var ColumnsContainerPropsDefaults = {
  columnsCount: 2,
  columnsGap: 0,
  contentAlignment: "middle"
};
function ColumnsContainer({ style, columns, props }) {
  var _a, _b, _c, _d;
  const wStyle = {
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  const blockProps = {
    columnsCount: (_b = props == null ? void 0 : props.columnsCount) != null ? _b : ColumnsContainerPropsDefaults.columnsCount,
    columnsGap: (_c = props == null ? void 0 : props.columnsGap) != null ? _c : ColumnsContainerPropsDefaults.columnsGap,
    contentAlignment: (_d = props == null ? void 0 : props.contentAlignment) != null ? _d : ColumnsContainerPropsDefaults.contentAlignment,
    fixedWidths: props == null ? void 0 : props.fixedWidths
  };
  return /* @__PURE__ */ import_react.default.createElement("div", { style: wStyle }, /* @__PURE__ */ import_react.default.createElement(
    "table",
    {
      align: "center",
      width: "100%",
      cellPadding: "0",
      border: 0,
      style: { tableLayout: "fixed", borderCollapse: "collapse" }
    },
    /* @__PURE__ */ import_react.default.createElement("tbody", { style: { width: "100%" } }, /* @__PURE__ */ import_react.default.createElement("tr", { style: { width: "100%" } }, /* @__PURE__ */ import_react.default.createElement(TableCell, { index: 0, props: blockProps, columns }), /* @__PURE__ */ import_react.default.createElement(TableCell, { index: 1, props: blockProps, columns }), /* @__PURE__ */ import_react.default.createElement(TableCell, { index: 2, props: blockProps, columns })))
  ));
}
function TableCell({ index, props, columns }) {
  var _a, _b, _c, _d, _e;
  const contentAlignment = (_a = props == null ? void 0 : props.contentAlignment) != null ? _a : ColumnsContainerPropsDefaults.contentAlignment;
  const columnsCount = (_b = props == null ? void 0 : props.columnsCount) != null ? _b : ColumnsContainerPropsDefaults.columnsCount;
  if (columnsCount === 2 && index === 2) {
    return null;
  }
  const style = {
    boxSizing: "content-box",
    verticalAlign: contentAlignment,
    paddingLeft: getPaddingBefore(index, props),
    paddingRight: getPaddingAfter(index, props),
    width: (_d = (_c = props.fixedWidths) == null ? void 0 : _c[index]) != null ? _d : void 0
  };
  const children = (_e = columns && columns[index]) != null ? _e : null;
  return /* @__PURE__ */ import_react.default.createElement("td", { style }, children);
}
function getPaddingBefore(index, { columnsGap, columnsCount }) {
  if (index === 0) {
    return 0;
  }
  if (columnsCount === 2) {
    return columnsGap / 2;
  }
  if (index === 1) {
    return columnsGap / 3;
  }
  return 2 * columnsGap / 3;
}
function getPaddingAfter(index, { columnsGap, columnsCount }) {
  if (columnsCount === 2) {
    if (index === 0) {
      return columnsGap / 2;
    }
    return 0;
  }
  if (index === 0) {
    return 2 * columnsGap / 3;
  }
  if (index === 1) {
    return columnsGap / 3;
  }
  return 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ColumnsContainer,
  ColumnsContainerPropsSchema
});
