"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Divider: () => Divider,
  DividerPropsDefaults: () => DividerPropsDefaults,
  DividerPropsSchema: () => DividerPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var DividerPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    backgroundColor: COLOR_SCHEMA,
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    lineColor: COLOR_SCHEMA,
    lineHeight: import_zod.z.number().optional().nullable()
  }).optional().nullable()
});
var DividerPropsDefaults = {
  lineHeight: 1,
  lineColor: "#333333"
};
function Divider({ style, props }) {
  var _a, _b, _c;
  const st = {
    padding: getPadding(style == null ? void 0 : style.padding),
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0
  };
  const borderTopWidth = (_b = props == null ? void 0 : props.lineHeight) != null ? _b : DividerPropsDefaults.lineHeight;
  const borderTopColor = (_c = props == null ? void 0 : props.lineColor) != null ? _c : DividerPropsDefaults.lineColor;
  return /* @__PURE__ */ import_react.default.createElement("div", { style: st }, /* @__PURE__ */ import_react.default.createElement(
    "hr",
    {
      style: {
        width: "100%",
        border: "none",
        borderTop: `${borderTopWidth}px solid ${borderTopColor}`,
        margin: 0
      }
    }
  ));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Divider,
  DividerPropsDefaults,
  DividerPropsSchema
});
