"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Html: () => Html,
  HtmlPropsSchema: () => HtmlPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var FONT_FAMILY_SCHEMA = import_zod.z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
function getFontFamily(fontFamily) {
  switch (fontFamily) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
  return void 0;
}
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var HtmlPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    color: COLOR_SCHEMA,
    backgroundColor: COLOR_SCHEMA,
    fontFamily: FONT_FAMILY_SCHEMA,
    fontSize: import_zod.z.number().min(0).optional().nullable(),
    textAlign: import_zod.z.enum(["left", "right", "center"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    contents: import_zod.z.string().optional().nullable()
  }).optional().nullable()
});
function Html({ style, props }) {
  var _a, _b, _c, _d;
  const children = props == null ? void 0 : props.contents;
  const cssStyle = {
    color: (_a = style == null ? void 0 : style.color) != null ? _a : void 0,
    backgroundColor: (_b = style == null ? void 0 : style.backgroundColor) != null ? _b : void 0,
    fontFamily: getFontFamily(style == null ? void 0 : style.fontFamily),
    fontSize: (_c = style == null ? void 0 : style.fontSize) != null ? _c : void 0,
    textAlign: (_d = style == null ? void 0 : style.textAlign) != null ? _d : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  if (!children) {
    return /* @__PURE__ */ import_react.default.createElement("div", { style: cssStyle });
  }
  return /* @__PURE__ */ import_react.default.createElement("div", { style: cssStyle, dangerouslySetInnerHTML: { __html: children } });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Html,
  HtmlPropsSchema
});
