// src/index.tsx
import React from "react";
import { z } from "zod";
var FONT_FAMILY_SCHEMA = z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
function getFontFamily(fontFamily) {
  switch (fontFamily) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
  return void 0;
}
var COLOR_SCHEMA = z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var HtmlPropsSchema = z.object({
  style: z.object({
    color: COLOR_SCHEMA,
    backgroundColor: COLOR_SCHEMA,
    fontFamily: FONT_FAMILY_SCHEMA,
    fontSize: z.number().min(0).optional().nullable(),
    textAlign: z.enum(["left", "right", "center"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: z.object({
    contents: z.string().optional().nullable()
  }).optional().nullable()
});
function Html({ style, props }) {
  var _a, _b, _c, _d;
  const children = props == null ? void 0 : props.contents;
  const cssStyle = {
    color: (_a = style == null ? void 0 : style.color) != null ? _a : void 0,
    backgroundColor: (_b = style == null ? void 0 : style.backgroundColor) != null ? _b : void 0,
    fontFamily: getFontFamily(style == null ? void 0 : style.fontFamily),
    fontSize: (_c = style == null ? void 0 : style.fontSize) != null ? _c : void 0,
    textAlign: (_d = style == null ? void 0 : style.textAlign) != null ? _d : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  if (!children) {
    return /* @__PURE__ */ React.createElement("div", { style: cssStyle });
  }
  return /* @__PURE__ */ React.createElement("div", { style: cssStyle, dangerouslySetInnerHTML: { __html: children } });
}
export {
  Html,
  HtmlPropsSchema
};
