"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Image: () => Image,
  ImagePropsSchema: () => ImagePropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ImagePropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    padding: PADDING_SCHEMA,
    backgroundColor: import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).optional().nullable(),
    textAlign: import_zod.z.enum(["center", "left", "right"]).optional().nullable()
  }).optional().nullable(),
  props: import_zod.z.object({
    width: import_zod.z.number().optional().nullable(),
    height: import_zod.z.number().optional().nullable(),
    url: import_zod.z.string().optional().nullable(),
    alt: import_zod.z.string().optional().nullable(),
    linkHref: import_zod.z.string().optional().nullable(),
    contentAlignment: import_zod.z.enum(["top", "middle", "bottom"]).optional().nullable()
  }).optional().nullable()
});
function Image({ style, props }) {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const sectionStyle = {
    padding: getPadding(style == null ? void 0 : style.padding),
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0,
    textAlign: (_b = style == null ? void 0 : style.textAlign) != null ? _b : void 0
  };
  const linkHref = (_c = props == null ? void 0 : props.linkHref) != null ? _c : null;
  const width = (_d = props == null ? void 0 : props.width) != null ? _d : void 0;
  const height = (_e = props == null ? void 0 : props.height) != null ? _e : void 0;
  const imageElement = /* @__PURE__ */ import_react.default.createElement(
    "img",
    {
      alt: (_f = props == null ? void 0 : props.alt) != null ? _f : "",
      src: (_g = props == null ? void 0 : props.url) != null ? _g : "",
      width,
      height,
      style: {
        width,
        height,
        outline: "none",
        border: "none",
        textDecoration: "none",
        verticalAlign: (_h = props == null ? void 0 : props.contentAlignment) != null ? _h : "middle",
        display: "inline-block",
        maxWidth: "100%"
      }
    }
  );
  if (!linkHref) {
    return /* @__PURE__ */ import_react.default.createElement("div", { style: sectionStyle }, imageElement);
  }
  return /* @__PURE__ */ import_react.default.createElement("div", { style: sectionStyle }, /* @__PURE__ */ import_react.default.createElement("a", { href: linkHref, style: { textDecoration: "none" }, target: "_blank" }, imageElement));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Image,
  ImagePropsSchema
});
