"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Text: () => Text,
  TextPropsDefaults: () => TextPropsDefaults,
  TextPropsSchema: () => TextPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react2 = __toESM(require("react"));
var import_zod = require("zod");

// src/EmailMarkdown.tsx
var import_insane = __toESM(require("insane"));
var import_marked = require("marked");
var import_react = __toESM(require("react"));
var ALLOWED_TAGS = [
  "a",
  "article",
  "b",
  "blockquote",
  "br",
  "caption",
  "code",
  "del",
  "details",
  "div",
  "em",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "hr",
  "i",
  "img",
  "ins",
  "kbd",
  "li",
  "main",
  "ol",
  "p",
  "pre",
  "section",
  "span",
  "strong",
  "sub",
  "summary",
  "sup",
  "table",
  "tbody",
  "td",
  "th",
  "thead",
  "tr",
  "u",
  "ul"
];
var GENERIC_ALLOWED_ATTRIBUTES = ["style", "title"];
function sanitizer(html) {
  return (0, import_insane.default)(html, {
    allowedTags: ALLOWED_TAGS,
    allowedAttributes: __spreadProps(__spreadValues({}, ALLOWED_TAGS.reduce((res, tag) => {
      res[tag] = [...GENERIC_ALLOWED_ATTRIBUTES];
      return res;
    }, {})), {
      img: ["src", "srcset", "alt", "width", "height", ...GENERIC_ALLOWED_ATTRIBUTES],
      table: ["width", ...GENERIC_ALLOWED_ATTRIBUTES],
      td: ["align", "width", ...GENERIC_ALLOWED_ATTRIBUTES],
      th: ["align", "width", ...GENERIC_ALLOWED_ATTRIBUTES],
      a: ["href", "target", ...GENERIC_ALLOWED_ATTRIBUTES],
      ol: ["start", ...GENERIC_ALLOWED_ATTRIBUTES],
      ul: ["start", ...GENERIC_ALLOWED_ATTRIBUTES]
    })
  });
}
var CustomRenderer = class extends import_marked.Renderer {
  table(header, body) {
    return `<table width="100%">
<thead>
${header}</thead>
<tbody>
${body}</tbody>
</table>`;
  }
  link(href, title, text) {
    if (!title) {
      return `<a href="${href}" target="_blank">${text}</a>`;
    }
    return `<a href="${href}" title="${title}" target="_blank">${text}</a>`;
  }
};
function renderMarkdownString(str) {
  const html = import_marked.marked.parse(str, {
    async: false,
    breaks: true,
    gfm: true,
    pedantic: false,
    silent: false,
    renderer: new CustomRenderer()
  });
  if (typeof html !== "string") {
    throw new Error("marked.parse did not return a string");
  }
  return sanitizer(html);
}
function EmailMarkdown(_a) {
  var _b = _a, { markdown } = _b, props = __objRest(_b, ["markdown"]);
  const data = (0, import_react.useMemo)(() => renderMarkdownString(markdown), [markdown]);
  return /* @__PURE__ */ import_react.default.createElement("div", __spreadProps(__spreadValues({}, props), { dangerouslySetInnerHTML: { __html: data } }));
}

// src/index.tsx
var FONT_FAMILY_SCHEMA = import_zod.z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
function getFontFamily(fontFamily) {
  switch (fontFamily) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
  return void 0;
}
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var TextPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    color: COLOR_SCHEMA,
    backgroundColor: COLOR_SCHEMA,
    fontSize: import_zod.z.number().gte(0).optional().nullable(),
    fontFamily: FONT_FAMILY_SCHEMA,
    fontWeight: import_zod.z.enum(["bold", "normal"]).optional().nullable(),
    textAlign: import_zod.z.enum(["left", "center", "right"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: import_zod.z.object({
    markdown: import_zod.z.boolean().optional().nullable(),
    text: import_zod.z.string().optional().nullable()
  }).optional().nullable()
});
var TextPropsDefaults = {
  text: ""
};
function Text({ style, props }) {
  var _a, _b, _c, _d, _e, _f;
  const wStyle = {
    color: (_a = style == null ? void 0 : style.color) != null ? _a : void 0,
    backgroundColor: (_b = style == null ? void 0 : style.backgroundColor) != null ? _b : void 0,
    fontSize: (_c = style == null ? void 0 : style.fontSize) != null ? _c : void 0,
    fontFamily: getFontFamily(style == null ? void 0 : style.fontFamily),
    fontWeight: (_d = style == null ? void 0 : style.fontWeight) != null ? _d : void 0,
    textAlign: (_e = style == null ? void 0 : style.textAlign) != null ? _e : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  const text = (_f = props == null ? void 0 : props.text) != null ? _f : TextPropsDefaults.text;
  if (props == null ? void 0 : props.markdown) {
    return /* @__PURE__ */ import_react2.default.createElement(EmailMarkdown, { style: wStyle, markdown: text });
  }
  return /* @__PURE__ */ import_react2.default.createElement("div", { style: wStyle }, text);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Text,
  TextPropsDefaults,
  TextPropsSchema
});
