var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/index.tsx
import React2 from "react";
import { z } from "zod";

// src/EmailMarkdown.tsx
import insane from "insane";
import { marked, Renderer } from "marked";
import React, { useMemo } from "react";
var ALLOWED_TAGS = [
  "a",
  "article",
  "b",
  "blockquote",
  "br",
  "caption",
  "code",
  "del",
  "details",
  "div",
  "em",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "hr",
  "i",
  "img",
  "ins",
  "kbd",
  "li",
  "main",
  "ol",
  "p",
  "pre",
  "section",
  "span",
  "strong",
  "sub",
  "summary",
  "sup",
  "table",
  "tbody",
  "td",
  "th",
  "thead",
  "tr",
  "u",
  "ul"
];
var GENERIC_ALLOWED_ATTRIBUTES = ["style", "title"];
function sanitizer(html) {
  return insane(html, {
    allowedTags: ALLOWED_TAGS,
    allowedAttributes: __spreadProps(__spreadValues({}, ALLOWED_TAGS.reduce((res, tag) => {
      res[tag] = [...GENERIC_ALLOWED_ATTRIBUTES];
      return res;
    }, {})), {
      img: ["src", "srcset", "alt", "width", "height", ...GENERIC_ALLOWED_ATTRIBUTES],
      table: ["width", ...GENERIC_ALLOWED_ATTRIBUTES],
      td: ["align", "width", ...GENERIC_ALLOWED_ATTRIBUTES],
      th: ["align", "width", ...GENERIC_ALLOWED_ATTRIBUTES],
      a: ["href", "target", ...GENERIC_ALLOWED_ATTRIBUTES],
      ol: ["start", ...GENERIC_ALLOWED_ATTRIBUTES],
      ul: ["start", ...GENERIC_ALLOWED_ATTRIBUTES]
    })
  });
}
var CustomRenderer = class extends Renderer {
  table(header, body) {
    return `<table width="100%">
<thead>
${header}</thead>
<tbody>
${body}</tbody>
</table>`;
  }
  link(href, title, text) {
    if (!title) {
      return `<a href="${href}" target="_blank">${text}</a>`;
    }
    return `<a href="${href}" title="${title}" target="_blank">${text}</a>`;
  }
};
function renderMarkdownString(str) {
  const html = marked.parse(str, {
    async: false,
    breaks: true,
    gfm: true,
    pedantic: false,
    silent: false,
    renderer: new CustomRenderer()
  });
  if (typeof html !== "string") {
    throw new Error("marked.parse did not return a string");
  }
  return sanitizer(html);
}
function EmailMarkdown(_a) {
  var _b = _a, { markdown } = _b, props = __objRest(_b, ["markdown"]);
  const data = useMemo(() => renderMarkdownString(markdown), [markdown]);
  return /* @__PURE__ */ React.createElement("div", __spreadProps(__spreadValues({}, props), { dangerouslySetInnerHTML: { __html: data } }));
}

// src/index.tsx
var FONT_FAMILY_SCHEMA = z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
function getFontFamily(fontFamily) {
  switch (fontFamily) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
  return void 0;
}
var COLOR_SCHEMA = z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var TextPropsSchema = z.object({
  style: z.object({
    color: COLOR_SCHEMA,
    backgroundColor: COLOR_SCHEMA,
    fontSize: z.number().gte(0).optional().nullable(),
    fontFamily: FONT_FAMILY_SCHEMA,
    fontWeight: z.enum(["bold", "normal"]).optional().nullable(),
    textAlign: z.enum(["left", "center", "right"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: z.object({
    markdown: z.boolean().optional().nullable(),
    text: z.string().optional().nullable()
  }).optional().nullable()
});
var TextPropsDefaults = {
  text: ""
};
function Text({ style, props }) {
  var _a, _b, _c, _d, _e, _f;
  const wStyle = {
    color: (_a = style == null ? void 0 : style.color) != null ? _a : void 0,
    backgroundColor: (_b = style == null ? void 0 : style.backgroundColor) != null ? _b : void 0,
    fontSize: (_c = style == null ? void 0 : style.fontSize) != null ? _c : void 0,
    fontFamily: getFontFamily(style == null ? void 0 : style.fontFamily),
    fontWeight: (_d = style == null ? void 0 : style.fontWeight) != null ? _d : void 0,
    textAlign: (_e = style == null ? void 0 : style.textAlign) != null ? _e : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  const text = (_f = props == null ? void 0 : props.text) != null ? _f : TextPropsDefaults.text;
  if (props == null ? void 0 : props.markdown) {
    return /* @__PURE__ */ React2.createElement(EmailMarkdown, { style: wStyle, markdown: text });
  }
  return /* @__PURE__ */ React2.createElement("div", { style: wStyle }, text);
}
export {
  Text,
  TextPropsDefaults,
  TextPropsSchema
};
